"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExternalConnectorDocumentation = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExternalConnectorDocumentation = ({
  name,
  documentationUrl
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.workplaceSearch.contentSource.addExternalConnector.documentation.heading",
    defaultMessage: "The {name} is fully customizable, and will be self-managed on the infrastructure of your choice.",
    values: {
      name
    }
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.workplaceSearch.contentSource.addExternalConnector.documentation.description",
    defaultMessage: "To be prepared for configuration, review our {deploymentGuideLink} for all prerequisites needed to quickly deploy the connector package. Finalize your configuration in Enterprise Search by setting the connector's URL and API key in the next step.",
    values: {
      deploymentGuideLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: documentationUrl
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.workplaceSearch.contentSource.addExternalConnector.documentation.linkLabel",
        defaultMessage: "documentation"
      }))
    }
  })));
};
exports.ExternalConnectorDocumentation = ExternalConnectorDocumentation;