"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkplaceSearchPageTemplate = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _constants = require("../../../../../common/constants");
var _kibana = require("../../../shared/kibana");
var _kibana_chrome = require("../../../shared/kibana_chrome");
var _layout = require("../../../shared/layout");
var _telemetry = require("../../../shared/telemetry");
var _nav = require("./nav");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WorkplaceSearchPageTemplate = ({
  children,
  pageChrome,
  pageViewTelemetry,
  ...pageTemplateProps
}) => {
  const navItems = (0, _nav.useWorkplaceSearchNav)();
  const {
    getChromeStyle$,
    updateSideNavDefinition
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const chromeStyle = (0, _useObservable.default)(getChromeStyle$(), 'classic');
  _react.default.useEffect(() => {
    var _navItems$;
    if (chromeStyle === 'classic') return;
    // We update the new side nav definition with the selected app items
    updateSideNavDefinition({
      workplaceSearch: navItems === null || navItems === void 0 ? void 0 : (_navItems$ = navItems[0]) === null || _navItems$ === void 0 ? void 0 : _navItems$.items
    });
  }, [chromeStyle, navItems, updateSideNavDefinition]);
  _react.default.useEffect(() => {
    return () => {
      updateSideNavDefinition({
        workplaceSearch: undefined
      });
    };
  }, [updateSideNavDefinition]);
  return /*#__PURE__*/_react.default.createElement(_layout.EnterpriseSearchPageTemplateWrapper, (0, _extends2.default)({
    restrictWidth: true
  }, pageTemplateProps, {
    solutionNav: {
      items: chromeStyle === 'classic' ? navItems : undefined,
      name: _constants.WORKPLACE_SEARCH_PLUGIN.NAME
    },
    setPageChrome: pageChrome && /*#__PURE__*/_react.default.createElement(_kibana_chrome.SetWorkplaceSearchChrome, {
      trail: pageChrome
    }),
    useEndpointHeaderActions: false,
    hideEmbeddedConsole: true
  }), pageViewTelemetry && /*#__PURE__*/_react.default.createElement(_telemetry.SendWorkplaceSearchTelemetry, {
    action: "viewed",
    metric: pageViewTelemetry
  }), children);
};
exports.WorkplaceSearchPageTemplate = WorkplaceSearchPageTemplate;