"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useWorkplaceSearchNav = void 0;
var _layout = require("../../../shared/layout");
var _constants = require("../../constants");
var _routes = require("../../routes");
var _source_sub_nav = require("../../views/content_sources/components/source_sub_nav");
var _group_sub_nav = require("../../views/groups/components/group_sub_nav");
var _settings_sub_nav = require("../../views/settings/components/settings_sub_nav");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useWorkplaceSearchNav = () => {
  const navItems = [{
    id: 'root',
    name: _constants.NAV.OVERVIEW,
    ...(0, _layout.generateNavLink)({
      to: ''
    })
  }, {
    id: 'sources',
    name: _constants.NAV.SOURCES,
    ...(0, _layout.generateNavLink)({
      to: _routes.SOURCES_PATH,
      shouldShowActiveForSubroutes: true,
      items: (0, _source_sub_nav.useSourceSubNav)()
    })
  }, {
    id: 'groups',
    name: _constants.NAV.GROUPS,
    ...(0, _layout.generateNavLink)({
      to: _routes.GROUPS_PATH
    }),
    items: (0, _group_sub_nav.useGroupSubNav)()
  }, {
    id: 'usersRoles',
    name: _constants.NAV.ROLE_MAPPINGS,
    ...(0, _layout.generateNavLink)({
      to: _routes.USERS_AND_ROLES_PATH
    })
  }, {
    id: 'apiKeys',
    name: _constants.NAV.API_KEYS,
    ...(0, _layout.generateNavLink)({
      to: _routes.API_KEYS_PATH
    })
  }, {
    id: 'security',
    name: _constants.NAV.SECURITY,
    ...(0, _layout.generateNavLink)({
      to: _routes.SECURITY_PATH
    })
  }, {
    id: 'settings',
    name: _constants.NAV.SETTINGS,
    ...(0, _layout.generateNavLink)({
      to: _routes.ORG_SETTINGS_PATH
    }),
    items: (0, _settings_sub_nav.useSettingsSubNav)()
  }];

  // Root level items are meant to be section headers, but the WS nav (currently)
  // isn't organized this way. So we crate a fake empty parent item here
  // to cause all our navItems to properly render as nav links.
  return [{
    id: '',
    name: '',
    items: navItems
  }];
};
exports.useWorkplaceSearchNav = useWorkplaceSearchNav;