"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UsersTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("./constants");
var _2 = require(".");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const noItemsPlaceholder = /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
  color: "subdued"
}, "\u2014");
const invitationBadge = /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
  color: "hollow"
}, _constants.INVITATION_PENDING_LABEL);
const deactivatedBadge = /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
  color: "hollow"
}, _constants.DEACTIVATED_LABEL);
const UsersTable = ({
  accessItemKey,
  singleUserRoleMappings,
  initializeSingleUserRoleMapping,
  handleDeleteMapping
}) => {
  // 'accessItems' is needed because App Search has `engines` and Workplace Search has `groups`.
  const users = singleUserRoleMappings.map(user => ({
    username: user.elasticsearchUser.username,
    email: user.elasticsearchUser.email,
    enabled: user.elasticsearchUser.enabled,
    roleType: user.roleMapping.roleType,
    id: user.roleMapping.id,
    accessItems: user.roleMapping[accessItemKey],
    accessAll: user.roleMapping[accessItemKey === 'engines' ? 'accessAllEngines' : 'allGroups'],
    invitation: user.invitation
  }));
  const [items, setItems] = (0, _react.useState)([]);
  (0, _react.useEffect)(() => {
    setItems(users);
  }, [singleUserRoleMappings]);
  const columns = [{
    field: 'username',
    name: _constants.USERNAME_LABEL,
    render: (_, {
      username,
      invitation,
      enabled
    }) => /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "UsernameCell"
    }, username, " ", !invitation && !enabled && deactivatedBadge)
  }, {
    field: 'email',
    name: _constants.EMAIL_LABEL,
    render: (_, {
      email,
      invitation
    }) => {
      if (!email) return noItemsPlaceholder;
      return /*#__PURE__*/_react.default.createElement("div", {
        "data-test-subj": "EmailDisplayValue"
      }, email, " ", invitation && invitationBadge);
    }
  }, {
    field: 'roleType',
    name: _constants.ROLE_LABEL,
    render: (_, user) => user.roleType
  }, {
    field: 'accessItems',
    name: accessItemKey === 'groups' ? _constants.GROUPS_LABEL : _constants.ENGINES_LABEL,
    render: (_, user) => /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "AccessItems"
    }, getAccessItemsContent(user))
  }, {
    field: 'id',
    name: '',
    align: 'right',
    render: (_, {
      id,
      username
    }) => /*#__PURE__*/_react.default.createElement(_2.UsersAndRolesRowActions, {
      username: username,
      onManageClick: () => initializeSingleUserRoleMapping(id),
      onDeleteClick: () => handleDeleteMapping(id)
    })
  }];
  const getAccessItemsContent = ({
    accessItems,
    accessAll
  }) => {
    const isAppSearch = accessItemKey === 'engines';
    const numItems = accessItems.length;
    if (numItems === 0) {
      // There is a possibility to add users without setting an access. We should not show 'All' in that case.
      return isAppSearch && !accessAll ? '-' : _constants.ALL_LABEL;
    }

    // Design calls for showing the first 2 items followed by a +x after those 2.
    // ['foo', 'bar', 'baz'] would display as: "foo, bar + 1"
    const additionalItems = numItems > 2 ? ` + ${numItems - 2}` : '';
    const names = accessItems.map(item => item.name);
    return names.slice(0, 2).join(', ') + additionalItems;
  };
  const pagination = {
    showPerPageOptions: false,
    pageSize: 10
  };
  const onQueryChange = ({
    queryText
  }) => {
    const filteredItems = users.filter(user => {
      // JSON.stringify allows us to search all the object fields
      // without converting all the nested arrays and objects to strings manually
      // Some false-positives are possible, because the search is also performed on
      // object keys, but the simplicity of JSON.stringify seems to worth the tradeoff.
      const normalizedTableItemString = JSON.stringify(user).toLowerCase();
      const normalizedQuery = queryText.toLowerCase();
      return normalizedTableItemString.indexOf(normalizedQuery) !== -1;
    });
    setItems(filteredItems);
  };
  const search = {
    onChange: onQueryChange,
    box: {
      incremental: true,
      fullWidth: false,
      placeholder: _constants.FILTER_USERS_LABEL,
      'data-test-subj': 'UsersTableSearchInput'
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    "data-test-subj": "UsersTable",
    columns: columns,
    items: items,
    search: search,
    pagination: pagination,
    message: _constants.NO_USERS_LABEL
  });
};
exports.UsersTable = UsersTable;