"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserAddedInfo = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../constants");
var _constants2 = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const kibanaAccessWarning = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  title: _constants2.KIBANA_ACCESS_WARNING_TITLE,
  color: "warning",
  iconType: "help"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s"
}, _constants2.KIBANA_ACCESS_WARNING_ERROR_MESSAGE), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s"
}, _constants2.KIBANA_ACCESS_WARNING_DESCRIPTION)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
const noItemsPlaceholder = /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
  color: "subdued"
}, "\u2014");
const UserAddedInfo = ({
  username,
  email,
  roleType,
  showKibanaAccessWarning
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showKibanaAccessWarning && kibanaAccessWarning, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s"
}, /*#__PURE__*/_react.default.createElement("strong", null, _constants.USERNAME_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s"
}, username), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s"
}, /*#__PURE__*/_react.default.createElement("strong", null, _constants.EMAIL_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s"
}, email || noItemsPlaceholder), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s"
}, /*#__PURE__*/_react.default.createElement("strong", null, _constants2.ROLE_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s"
}, roleType), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
exports.UserAddedInfo = UserAddedInfo;