"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.phpDefinition = void 0;
var _i18n = require("@kbn/i18n");
var _searchApiPanels = require("@kbn/search-api-panels");
var _doc_links = require("../../doc_links");
var _constants = require("./constants");
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const phpDefinition = exports.phpDefinition = {
  buildSearchQuery: ({
    indexName = _constants.INDEX_NAME_PLACEHOLDER
  }) => `$params = [
  'index' => '${indexName}',
  'body'  => [
    'q' => 'snow'
  ]
];

$response = $client->search($params);
print_r($response->asArray());`,
  configureClient: ({
    url,
    apiKey
  }) => `$client = ClientBuilder::create()
  ->setHosts(['${url}'])
  ->setApiKey('${apiKey}')
  ->build();`,
  docLink: _doc_links.docLinks.clientsPhpOverview,
  github: {
    label: _i18n.i18n.translate('xpack.enterpriseSearch.languages.php.githubLink', {
      defaultMessage: 'elasticsearch-php'
    }),
    link: 'https://github.com/elastic/elasticsearch-php'
  },
  iconType: 'php.svg',
  id: _searchApiPanels.Languages.PHP,
  ingestData: ({
    indexName = _constants.INDEX_NAME_PLACEHOLDER,
    ingestPipeline,
    extraIngestDocumentValues
  }) => {
    const ingestDocumentKeys = ingestPipeline ? (0, _helpers.ingestKeysToPHP)(extraIngestDocumentValues) : '';
    return `$params = [${ingestPipeline ? `\n  'pipeline' => '${ingestPipeline}',` : ''}
  'body' => [
  [
    'index' => [
    '_index' => '${indexName}',
    '_id' => '9780553351927',
  ],
  ],
  [
    'name' => 'Snow Crash',
    'author' => 'Neal Stephenson',
    'release_date' => '1992-06-01',
    'page_count' => 470,${ingestDocumentKeys}
  ],
  [
    'index' => [
    '_index' => '${indexName}',
    '_id' => '9780441017225',
  ],
  ],
  [
    'name' => 'Revelation Space',
    'author' => 'Alastair Reynolds',
    'release_date' => '2000-03-15',
    'page_count' => 585,${ingestDocumentKeys}
  ],
  [
    'index' => [
    '_index' => '${indexName}',
    '_id' => '9780451524935',
    ],
  ],
  [
    'name' => '1984',
    'author' => 'George Orwell',
    'release_date' => '1985-06-01',
    'page_count' => 328,${ingestDocumentKeys}
  ],
  [
    'index' => [
    '_index' => '${indexName}',
    '_id' => '9781451673319',
    ],
  ],
  [
    'name' => 'Fahrenheit 451',
    'author' => 'Ray Bradbury',
    'release_date' => '1953-10-15',
    'page_count' => 227,${ingestDocumentKeys}
  ],
  [
    'index' => [
    '_index' => '${indexName}',
    '_id' => '9780060850524',
    ],
  ],
  [
    'name' => 'Brave New World',
    'author' => 'Aldous Huxley',
    'release_date' => '1932-06-01',
    'page_count' => 268,${ingestDocumentKeys}
  ],
  [
    'index' => [
    '_index' => '${indexName}',
    '_id' => '9780385490818',
    ],
  ],
  [
    'name' => 'The Handmaid\\'s Tale',
    'author' => 'Margaret Atwood',
    'release_date' => '1985-06-01',
    'page_count' => 311,${ingestDocumentKeys}
  ],
  ],
  ];

  $response = $client->bulk($params);
  echo $response->getStatusCode();
  echo (string) $response->getBody();`;
  },
  ingestDataIndex: '',
  installClient: 'composer require elasticsearch/elasticsearch',
  name: _i18n.i18n.translate('xpack.enterpriseSearch.languages.php', {
    defaultMessage: 'PHP'
  }),
  testConnection: `// API Key should have cluster monitor rights.
$response = $client->info();
echo $response->getStatusCode();
echo (string) $response->getBody();`
};