"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorStatePrompt = exports.ErrorStateCallout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _http = require("../http");
var _kibana = require("../kibana");
var _react_router_helpers = require("../react_router_helpers");
require("./error_state_prompt.scss");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Personal dashboard urls begin with /p/
 * EX: http://localhost:5601/app/enterprise_search/workplace_search/p/sources
 */
const WORKPLACE_SEARCH_PERSONAL_DASHBOARD_PATH = '/p/';
const ErrorStatePrompt = () => {
  const {
    setChromeIsVisible,
    history
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const isWorkplaceSearchPersonalDashboardRoute = history.location.pathname.includes(WORKPLACE_SEARCH_PERSONAL_DASHBOARD_PATH);
  (0, _react.useEffect)(() => {
    // We hide the Kibana chrome for Workplace Search for Personal Dashboard routes. It is reenabled when the user enters the
    // Workplace Search organization admin section of the product. If the Enterprise Search API is not working, we never show
    // the chrome and this can have adverse effects when the user leaves thispage and returns to Kibana. To get around this,
    // we always show the chrome when the error state is shown, unless the user is visiting the Personal Dashboard.
    setChromeIsVisible(!isWorkplaceSearchPersonalDashboardRoute);
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "warning",
    iconColor: "danger",
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.errorConnectingState.title",
      defaultMessage: "Unable to connect"
    })),
    titleSize: "l",
    body: /*#__PURE__*/_react.default.createElement(ErrorBody, null),
    actions: [/*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonTo, {
      iconType: "help",
      fill: true,
      to: "/setup_guide"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.errorConnectingState.setupGuideCta",
      defaultMessage: "Review setup guide"
    }))]
  });
};
exports.ErrorStatePrompt = ErrorStatePrompt;
const ErrorStateCallout = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.errorConnectingCallout.title', {
      defaultMessage: 'Unable to connect to Enterprise Search'
    }),
    iconType: "warning",
    color: "warning"
  }, /*#__PURE__*/_react.default.createElement(ErrorBody, null), /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonTo, {
    iconType: "help",
    fill: true,
    to: "/setup_guide",
    color: "warning"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.errorConnectingCallout.setupGuideCta",
    defaultMessage: "Review setup guide"
  })));
};
exports.ErrorStateCallout = ErrorStateCallout;
const ErrorBody = () => {
  const {
    errorConnectingMessage
  } = (0, _kea.useValues)(_http.HttpLogic);
  const {
    config,
    cloud
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.errorConnectingState.description1",
    defaultMessage: "We can\u2019t establish a connection to Enterprise Search at the host URL {enterpriseSearchUrl} due to the following error:",
    values: {
      enterpriseSearchUrl: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: config.host,
        css: {
          overflowWrap: 'break-word'
        }
      }, config.host)
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    css: {
      textAlign: 'left'
    }
  }, errorConnectingMessage), cloud !== null && cloud !== void 0 && cloud.isCloudEnabled ? cloudError(cloud) : nonCloudError());
};
const cloudError = cloud => {
  const deploymentUrl = cloud === null || cloud === void 0 ? void 0 : cloud.deploymentUrl;
  return /*#__PURE__*/_react.default.createElement("p", {
    "data-test-subj": "CloudError"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.errorConnectingState.cloudErrorMessage",
    defaultMessage: "Does your Cloud deployment have Enterprise Search nodes running? {deploymentSettingsLink}",
    values: {
      deploymentSettingsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: `${deploymentUrl}/edit`
      }, _i18n.i18n.translate('xpack.enterpriseSearch.errorConnectingState.cloudErrorMessageLinkText', {
        defaultMessage: 'Check your deployment settings'
      }))
    }
  }));
};
const nonCloudError = () => {
  return /*#__PURE__*/_react.default.createElement("ol", {
    className: "troubleshootingSteps",
    "data-test-subj": "SelfManagedError"
  }, /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.errorConnectingState.description2",
    defaultMessage: "Ensure the host URL is configured correctly in {configFile}.",
    values: {
      configFile: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "config/kibana.yml")
    }
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.errorConnectingState.description3",
    defaultMessage: "Confirm that the Enterprise Search server is responsive."
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.errorConnectingState.troubleshootAuth",
    defaultMessage: "Check your user authentication:"
  }), /*#__PURE__*/_react.default.createElement("ul", null, /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.errorConnectingState.troubleshootAuthMessage",
    defaultMessage: "Contact your administrator to setup an Enterprise Search role mapping to give you access to Enterprise Search"
  })))));
};