"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProductCard = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _react_router_helpers = require("../../../shared/react_router_helpers");
var _telemetry = require("../../../shared/telemetry");
require("./product_card.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ProductCard = ({
  cta,
  description,
  emptyCta = false,
  hasBorder,
  hasShadow,
  icon,
  iconSize,
  productId,
  rightPanelItems,
  name,
  url
}) => {
  const {
    sendEnterpriseSearchTelemetry
  } = (0, _kea.useActions)(_telemetry.TelemetryLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: hasBorder !== null && hasBorder !== void 0 ? hasBorder : true,
    hasShadow: hasShadow !== null && hasShadow !== void 0 ? hasShadow : true,
    paddingSize: "l",
    "data-test-subj": `${productId}ProductCard`,
    className: "productCard"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "productCard-icon"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: iconSize !== null && iconSize !== void 0 ? iconSize : 'xl',
    type: icon
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "productCard-details"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, name)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, description, ' '), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), cta && url && /*#__PURE__*/_react.default.createElement("div", null, emptyCta ? /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonTo, {
    to: url,
    shouldNotCreateHref: true,
    onClick: () => sendEnterpriseSearchTelemetry({
      action: 'clicked',
      metric: (0, _lodash.snakeCase)(productId)
    })
  }, cta) : /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonEmptyTo, {
    flush: "both",
    to: url,
    shouldNotCreateHref: true,
    onClick: () => sendEnterpriseSearchTelemetry({
      action: 'clicked',
      metric: (0, _lodash.snakeCase)(productId)
    })
  }, cta))), rightPanelItems ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    "data-test-subj": "productCard-rightPanelItems"
  }, rightPanelItems.map((rightPanelItem, id) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: id
    }, rightPanelItem);
  }))) : null));
};
exports.ProductCard = ProductCard;