"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchApiKeys = exports.FetchApiKeysAPILogic = void 0;
var _create_api_logic = require("../../shared/api_logic/create_api_logic");
var _http = require("../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchApiKeys = async () => {
  const {
    http
  } = _http.HttpLogic.values;
  const route = '/internal/enterprise_search/api_keys';
  const response = await http.get(route);
  return response;
};
exports.fetchApiKeys = fetchApiKeys;
const FetchApiKeysAPILogic = exports.FetchApiKeysAPILogic = (0, _create_api_logic.createApiLogic)(['overview', 'api_keys_api_logic'], fetchApiKeys);