"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasConfiguredConfiguration = void 0;
var _is_category_entry = require("../../../../common/connectors/is_category_entry");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const hasConfiguredConfiguration = configuration => {
  return !Object.entries(configuration).find(([, pair]) => (0, _is_category_entry.isConfigEntry)(pair) && pair.required && (pair.value === undefined || pair.value === null));
};
exports.hasConfiguredConfiguration = hasConfiguredConfiguration;