"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isExampleConnector = exports.hasNonEmptyAdvancedSnippet = exports.hasIncrementalSyncFeature = exports.hasDocumentLevelSecurityFeature = exports.hasBasicFilteringFeature = exports.hasAdvancedFilteringFeature = void 0;
var _searchConnectors = require("@kbn/search-connectors");
var _constants = require("../../../../common/constants");
var _sync_rules_helpers = require("./sync_rules_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const hasIncrementalSyncFeature = connector => {
  var _connector$features, _connector$features$F;
  return (connector === null || connector === void 0 ? void 0 : (_connector$features = connector.features) === null || _connector$features === void 0 ? void 0 : (_connector$features$F = _connector$features[_searchConnectors.FeatureName.INCREMENTAL_SYNC]) === null || _connector$features$F === void 0 ? void 0 : _connector$features$F.enabled) || false;
};
exports.hasIncrementalSyncFeature = hasIncrementalSyncFeature;
const hasDocumentLevelSecurityFeature = connector => {
  var _connector$features2, _connector$features2$;
  return (connector === null || connector === void 0 ? void 0 : (_connector$features2 = connector.features) === null || _connector$features2 === void 0 ? void 0 : (_connector$features2$ = _connector$features2[_searchConnectors.FeatureName.DOCUMENT_LEVEL_SECURITY]) === null || _connector$features2$ === void 0 ? void 0 : _connector$features2$.enabled) || false;
};

// TODO remove this when example status is removed
exports.hasDocumentLevelSecurityFeature = hasDocumentLevelSecurityFeature;
const isExampleConnector = connector => Boolean(connector && connector.service_type && _constants.EXAMPLE_CONNECTOR_SERVICE_TYPES.includes(connector.service_type));
exports.isExampleConnector = isExampleConnector;
const hasAdvancedFilteringFeature = connector => {
  var _connector$features$F2, _connector$features$F3, _connector$features$F4;
  return Boolean(connector !== null && connector !== void 0 && connector.features ? (_connector$features$F2 = (_connector$features$F3 = connector.features[_searchConnectors.FeatureName.SYNC_RULES]) === null || _connector$features$F3 === void 0 ? void 0 : (_connector$features$F4 = _connector$features$F3.advanced) === null || _connector$features$F4 === void 0 ? void 0 : _connector$features$F4.enabled) !== null && _connector$features$F2 !== void 0 ? _connector$features$F2 : connector.features[_searchConnectors.FeatureName.FILTERING_ADVANCED_CONFIG] : false);
};
exports.hasAdvancedFilteringFeature = hasAdvancedFilteringFeature;
const hasBasicFilteringFeature = connector => {
  var _connector$features$F5, _connector$features$F6, _connector$features$F7;
  return Boolean(connector !== null && connector !== void 0 && connector.features ? (_connector$features$F5 = (_connector$features$F6 = connector.features[_searchConnectors.FeatureName.SYNC_RULES]) === null || _connector$features$F6 === void 0 ? void 0 : (_connector$features$F7 = _connector$features$F6.basic) === null || _connector$features$F7 === void 0 ? void 0 : _connector$features$F7.enabled) !== null && _connector$features$F5 !== void 0 ? _connector$features$F5 : connector.features[_searchConnectors.FeatureName.FILTERING_RULES] : false);
};
exports.hasBasicFilteringFeature = hasBasicFilteringFeature;
const hasNonEmptyAdvancedSnippet = (connector, advancedSnippet) => Boolean(connector && connector.status && hasAdvancedFilteringFeature(connector) && !(0, _sync_rules_helpers.isAdvancedSyncRuleSnippetEmpty)(advancedSnippet));
exports.hasNonEmptyAdvancedSnippet = hasNonEmptyAdvancedSnippet;