"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmptyStatePanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _crawler_logic = require("../crawler_logic");
var _add_domain_form = require("./add_domain/add_domain_form");
var _add_domain_form_errors = require("./add_domain/add_domain_form_errors");
var _add_domain_form_submit_button = require("./add_domain/add_domain_form_submit_button");
var _add_domain_logic = require("./add_domain/add_domain_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EmptyStatePanel = () => {
  const {
    openFlyout
  } = (0, _kea.useActions)(_add_domain_logic.AddDomainLogic);
  const {
    events
  } = (0, _kea.useValues)(_crawler_logic.CrawlerLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.domainManagement.emptyState.title', {
    defaultMessage: 'Add a domain to your index'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.domainManagement.emptyState.description', {
    defaultMessage: 'Configure the domains you’d like to crawl, and when ready trigger your first crawl.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), events.length > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.domainManagement.emptyState', {
    defaultMessage: 'You don’t have any domains on this index. Add your first domain to start crawling and indexing documents.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-telemetry-id": "entSearchContent-crawler-domainManagement-noDomains-addFirstDomain",
    onClick: openFlyout,
    fill: true
  }, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.domainManagement.emptyState.addDomainButtonLabel', {
    defaultMessage: 'Add your first domain'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank"
  }, "Learn more")))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_add_domain_form_errors.AddDomainFormErrors, null), /*#__PURE__*/_react.default.createElement(_add_domain_form.AddDomainForm, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_add_domain_form_submit_button.AddDomainFormSubmitButton, null)));
};
exports.EmptyStatePanel = EmptyStatePanel;