"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.readableCrawlerStatuses = exports.readableCrawlTypes = exports.crawlStatusColors = void 0;
var _i18n = require("@kbn/i18n");
var _types = require("../../../../api/crawler/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const readableCrawlTypes = exports.readableCrawlTypes = {
  [_types.CrawlType.Full]: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlTypeOptions.full', {
    defaultMessage: 'Full'
  }),
  [_types.CrawlType.Partial]: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlTypeOptions.partial', {
    defaultMessage: 'Partial'
  })
};
const readableCrawlerStatuses = exports.readableCrawlerStatuses = {
  [_types.CrawlerStatus.Pending]: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlerStatusOptions.pending', {
    defaultMessage: 'Pending'
  }),
  [_types.CrawlerStatus.Suspended]: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlerStatusOptions.suspended', {
    defaultMessage: 'Suspended'
  }),
  [_types.CrawlerStatus.Starting]: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlerStatusOptions.starting', {
    defaultMessage: 'Starting'
  }),
  [_types.CrawlerStatus.Running]: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlerStatusOptions.running', {
    defaultMessage: 'Running'
  }),
  [_types.CrawlerStatus.Suspending]: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlerStatusOptions.suspending', {
    defaultMessage: 'Suspending'
  }),
  [_types.CrawlerStatus.Canceling]: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlerStatusOptions.canceling', {
    defaultMessage: 'Canceling'
  }),
  [_types.CrawlerStatus.Success]: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlerStatusOptions.success', {
    defaultMessage: 'Success'
  }),
  [_types.CrawlerStatus.Failed]: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlerStatusOptions.failed', {
    defaultMessage: 'Failed'
  }),
  [_types.CrawlerStatus.Canceled]: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlerStatusOptions.canceled', {
    defaultMessage: 'Canceled'
  }),
  [_types.CrawlerStatus.Skipped]: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlerStatusOptions.skipped', {
    defaultMessage: 'Skipped'
  })
};
const crawlStatusColors = exports.crawlStatusColors = {
  [_types.CrawlerStatus.Pending]: 'default',
  [_types.CrawlerStatus.Suspended]: 'default',
  [_types.CrawlerStatus.Starting]: 'default',
  [_types.CrawlerStatus.Running]: 'default',
  [_types.CrawlerStatus.Suspending]: 'default',
  [_types.CrawlerStatus.Canceling]: 'default',
  [_types.CrawlerStatus.Success]: 'success',
  [_types.CrawlerStatus.Failed]: 'danger',
  [_types.CrawlerStatus.Canceled]: 'default',
  [_types.CrawlerStatus.Skipped]: 'default'
};