"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewIndex = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../common/constants");
var _http = require("../../../shared/http");
var _kibana_logic = require("../../../shared/kibana/kibana_logic");
var _routes = require("../../routes");
var _page_template = require("../layout/page_template");
var _cannot_connect = require("../search_index/components/cannot_connect");
var _search_indices = require("../search_indices");
var _new_index_card = require("./new_index_card");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAvailableMethodOptions = productFeatures => {
  return [_constants.INGESTION_METHOD_IDS.API, ...(productFeatures.hasWebCrawler ? [_constants.INGESTION_METHOD_IDS.CRAWLER] : []), ...(productFeatures.hasConnectors ? [_constants.INGESTION_METHOD_IDS.CONNECTOR] : [])];
};
const NewIndex = () => {
  const {
    config,
    productFeatures
  } = (0, _kea.useValues)(_kibana_logic.KibanaLogic);
  const availableIngestionMethodOptions = getAvailableMethodOptions(productFeatures);
  const {
    errorConnectingMessage
  } = (0, _kea.useValues)(_http.HttpLogic);
  return /*#__PURE__*/_react.default.createElement(_page_template.EnterpriseSearchContentPageTemplate, {
    pageChrome: [..._search_indices.baseBreadcrumbs, _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.breadcrumb', {
      defaultMessage: 'New ingestion method'
    })],
    pageViewTelemetry: "New Index",
    isLoading: false,
    pageHeader: {
      description: _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.pageDescription', {
        defaultMessage: 'Create a search optimized Elasticsearch index to store your content. Start by selecting an ingestion method.'
      }),
      pageTitle: _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.pageTitle', {
        defaultMessage: 'Select an ingestion method'
      })
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, errorConnectingMessage && productFeatures.hasWebCrawler && /*#__PURE__*/_react.default.createElement(_cannot_connect.CannotConnect, null), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, availableIngestionMethodOptions.map(type => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: type
  }, /*#__PURE__*/_react.default.createElement(_new_index_card.NewIndexCard, {
    disabled: Boolean(type === _constants.INGESTION_METHOD_IDS.CRAWLER && (errorConnectingMessage || !config.host)),
    type: type,
    onSelect: () => {
      if (type === _constants.INGESTION_METHOD_IDS.CONNECTOR) {
        _kibana_logic.KibanaLogic.values.navigateToUrl(_routes.NEW_INDEX_SELECT_CONNECTOR_PATH);
      } else if (type === _constants.INGESTION_METHOD_IDS.CRAWLER) {
        _kibana_logic.KibanaLogic.values.navigateToUrl(_routes.NEW_CRAWLER_PATH);
      } else {
        _kibana_logic.KibanaLogic.values.navigateToUrl(_routes.NEW_API_PATH);
      }
    }
  }))))))));
};
exports.NewIndex = NewIndex;