"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ButtonGroup = void 0;
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _eui = require("@elastic/eui");
require("./button_group.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ButtonGroup = ({
  onChange,
  options,
  selected
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  className: "buttonGroup",
  direction: "column",
  gutterSize: "m",
  role: "radiogroup"
}, options.map((option, index) => {
  const isSelected = option === selected;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: (0, _classnames.default)('buttonGroupOption', {
      'buttonGroupOption--selected': isSelected
    }),
    grow: false,
    key: index,
    onClick: () => {
      onChange(option);
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    borderRadius: "m",
    grow: true,
    hasBorder: true,
    hasShadow: false,
    className: "buttonGroupOption-panel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    color: "plain",
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, option.badge && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", null, option.badge), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, option.label)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, option.description))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    display: "base",
    iconType: isSelected ? 'check' : 'arrowRight',
    color: isSelected ? 'success' : 'primary',
    "aria-label": option.label,
    "aria-checked": isSelected,
    role: "radio",
    autoFocus: index === 0
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    color: isSelected ? 'success' : 'subdued',
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: isSelected ? 'success' : 'subdued'
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement("strong", null, option.footer))))));
}));
exports.ButtonGroup = ButtonGroup;