"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManualConfigurationFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../../../common/constants");
var _new_connector_logic = require("../../../new_index/method_connector/new_connector_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CLI_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.manualConfiguration.cliLabel', {
  defaultMessage: 'Command-line interface'
});
const CLI_LINK_TEXT = _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.manualConfiguration.cliLinkText', {
  defaultMessage: 'Connectors CLI'
});
const ManualConfigurationFlyout = ({
  flyoutContent,
  selfManagePreference,
  setIsFlyoutVisible
}) => {
  const simpleFlyoutTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'simpleFlyoutTitle'
  });
  const {
    connectorName
  } = (0, _kea.useValues)(_new_connector_logic.NewConnectorLogic);
  const {
    setRawName,
    createConnector
  } = (0, _kea.useActions)(_new_connector_logic.NewConnectorLogic);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: true,
    onClose: () => setIsFlyoutVisible(false),
    "aria-labelledby": simpleFlyoutTitleId,
    size: "s"
    // This fixes an a11y issue where the flyout was rendered below the Popover
    // Now we let get the focus back to the Popover is we close the Flyout
    ,
    maskProps: {
      style: `z-index: ${Number(euiTheme.levels.menu) + 1}`
    }
  }, flyoutContent === 'manual_config' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: simpleFlyoutTitleId
  }, _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.manualConfiguration.h2.cliLabel', {
    defaultMessage: 'Manual configuration'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.createConnector.flyoutManualConfigContent.p.thisManualOptionIsLabel",
    defaultMessage: "This manual option enables you to use an existing index and/or API key. It's an alternative to the automated {generateConfig} process.",
    values: {
      generateConfig: /*#__PURE__*/_react.default.createElement("b", null, _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.manualConfiguration.generateConfigLinkLabel', {
        defaultMessage: 'Generate configuration'
      }))
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.manualConfiguration.connectorName', {
    defaultMessage: 'Connector'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.startStep.euiFormRow.connectorNameLabel', {
      defaultMessage: 'Connector name'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "enterpriseSearchStartStepFieldText",
    fullWidth: true,
    name: "first",
    value: connectorName,
    onChange: e => {
      setRawName(e.target.value);
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.manualConfiguration.p.connectorNameDescription', {
    defaultMessage: "You'll be redirected to the connector page to complete your configuration."
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "enterpriseSearchFlyoutManualConfigContentCloseButton",
    iconType: "cross",
    onClick: () => setIsFlyoutVisible(false),
    flush: "left"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.flyoutManualConfigContent.closeButtonEmptyLabel', {
    defaultMessage: 'Close'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "enterpriseSearchFlyoutManualConfigContentSaveButton",
    onClick: () => {
      createConnector({
        isSelfManaged: selfManagePreference === 'selfManaged',
        shouldGenerateAfterCreate: false,
        shouldNavigateToConnectorAfterCreate: true
      });
    },
    fill: true
  }, _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.flyoutManualConfigContent.saveConfigurationButtonLabel', {
    defaultMessage: 'Save configuration'
  })))))), flyoutContent === 'client' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: simpleFlyoutTitleId
  }, CLI_LABEL))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.createConnector.manualConfiguration.p.youCanAlsoUseLabel",
    defaultMessage: "You can also use the {cliLink} to create and manage connectors. The following command creates a new connector using the {myIndex} index. Configuration is defined in your {configFile} file.",
    values: {
      cliLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "enterpriseSearchManualConfigurationConnectorsCliLink",
        href: "https://github.com/elastic/connectors/blob/main/docs/CLI.md",
        target: "_blank",
        external: true
      }, CLI_LINK_TEXT),
      myIndex: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "my-index"),
      configFile: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "config.yml")
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "bash",
    isCopyable: true
  }, _constants.CREATE_CONNECTOR_PLUGIN.CLI_SNIPPET))));
};
exports.ManualConfigurationFlyout = ManualConfigurationFlyout;