"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChooseConnectorSelectable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _connector = _interopRequireDefault(require("../../../../../../assets/images/connector.svg"));
var _kibana = require("../../../../../shared/kibana");
var _new_connector_logic = require("../../../new_index/method_connector/new_connector_logic");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ChooseConnectorSelectable = ({
  selfManaged
}) => {
  var _selectedConnector$ic;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [selectedOption, setSelectedOption] = (0, _react.useState)([]);
  const renderOption = (option, searchValue, contentClassName) => {
    const {
      _append,
      key,
      label,
      _prepend
    } = option;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "m",
      key: key + '-span',
      justifyContent: "spaceBetween",
      className: contentClassName
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "m"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, _prepend), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      textAlign: "left"
    }, label))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, _append));
  };
  const [selectableOptions, selectableSetOptions] = (0, _react.useState)([]);
  const {
    connectorTypes
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const allConnectors = (0, _react.useMemo)(() => connectorTypes.sort((a, b) => a.name.localeCompare(b.name)), [connectorTypes]);
  const {
    selectedConnector
  } = (0, _kea.useValues)(_new_connector_logic.NewConnectorLogic);
  const {
    setSelectedConnector
  } = (0, _kea.useActions)(_new_connector_logic.NewConnectorLogic);
  const getInitialOptions = () => {
    return allConnectors.map((connector, key) => {
      const _append = [];
      if (connector.isTechPreview) {
        _append.push(/*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          key: key + '-preview',
          iconType: "beaker",
          color: "hollow"
        }, _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.chooseConnectorSelectable.thechPreviewBadgeLabel', {
          defaultMessage: 'Tech preview'
        })));
      }
      if (connector.isBeta) {
        _append.push(/*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          key: key + '-beta',
          iconType: 'beta',
          color: "hollow"
        }, _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.chooseConnectorSelectable.BetaBadgeLabel', {
          defaultMessage: 'Beta'
        })));
      }
      if (selfManaged === 'native' && !connector.isNative) {
        _append.push(/*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          key: key + '-self',
          iconType: 'warning',
          color: "warning"
        }, _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.chooseConnectorSelectable.OnlySelfManagedBadgeLabel', {
          defaultMessage: 'Self managed'
        })));
      }
      return {
        _append,
        _prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          size: "l",
          type: connector.iconPath
        }),
        key: key.toString(),
        label: connector.name
      };
    });
  };
  const initialOptions = getInitialOptions();
  (0, _react.useEffect)(() => {
    selectableSetOptions(initialOptions);
  }, [selfManaged]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.chooseConnectorSelectable.euiComboBox.accessibleScreenReaderLabelLabel', {
      defaultMessage: 'Select a data source for your connector to use.'
    }),
    prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: (_selectedConnector$ic = selectedConnector === null || selectedConnector === void 0 ? void 0 : selectedConnector.iconPath) !== null && _selectedConnector$ic !== void 0 ? _selectedConnector$ic : _connector.default,
      size: "l"
    }),
    singleSelection: true,
    fullWidth: true,
    placeholder: _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.chooseConnectorSelectable.placeholder.text', {
      defaultMessage: 'Choose a data source'
    }),
    options: selectableOptions,
    selectedOptions: selectedOption,
    onChange: selectedItem => {
      setSelectedOption(selectedItem);
      if (selectedItem.length === 0) {
        setSelectedConnector(null);
        return;
      }
      const keySelected = Number(selectedItem[0].key);
      setSelectedConnector(allConnectors[keySelected]);
    },
    renderOption: renderOption,
    rowHeight: euiTheme.base / 2 * 5
  }));
};
exports.ChooseConnectorSelectable = ChooseConnectorSelectable;