"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateHtmlExtraction = exports.UpdateHtmlExtractionApiLogic = void 0;
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const updateHtmlExtraction = async ({
  htmlExtraction,
  indexName
}) => {
  const route = `/internal/enterprise_search/indices/${indexName}/crawler/html_extraction`;
  const params = {
    extract_full_html: htmlExtraction
  };
  await _http.HttpLogic.values.http.put(route, {
    body: JSON.stringify(params)
  });
  return {
    htmlExtraction
  };
};
exports.updateHtmlExtraction = updateHtmlExtraction;
const UpdateHtmlExtractionApiLogic = exports.UpdateHtmlExtractionApiLogic = (0, _create_api_logic.createApiLogic)(['update_html_extraction_api_logic'], updateHtmlExtraction);