"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteSearchApplicationModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../shared/constants");
var _telemetry_logic = require("../../../shared/telemetry/telemetry_logic");
var _search_applications_list_logic = require("./search_applications_list_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DeleteSearchApplicationModal = ({
  searchApplicationName,
  onClose
}) => {
  const {
    deleteSearchApplication
  } = (0, _kea.useActions)(_search_applications_list_logic.SearchApplicationsListLogic);
  const {
    sendEnterpriseSearchTelemetry
  } = (0, _kea.useActions)(_telemetry_logic.TelemetryLogic);
  const {
    isDeleteLoading
  } = (0, _kea.useValues)(_search_applications_list_logic.SearchApplicationsListLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.list.deleteSearchApplicationModal.title', {
      defaultMessage: 'Permanently delete this search application?'
    }),
    onCancel: onClose,
    onConfirm: () => {
      deleteSearchApplication({
        searchApplicationName
      });
      sendEnterpriseSearchTelemetry({
        action: 'clicked',
        metric: 'entSearchApplications-deleteSearchApplicationConfirm'
      });
    },
    cancelButtonText: _constants.CANCEL_BUTTON_LABEL,
    confirmButtonText: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.list.deleteSearchApplicationModal.confirmButton.title', {
      defaultMessage: 'Yes, delete this search application'
    }),
    buttonColor: "danger",
    isLoading: isDeleteLoading
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.list.deleteSearchApplicationModal.delete.description', {
    defaultMessage: 'Deleting your search application is not a reversible action. Your indices will not be affected. '
  })));
};
exports.DeleteSearchApplicationModal = DeleteSearchApplicationModal;