"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SchemaTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _schema = require("../../../../shared/schema");
var _constants = require("../../../../shared/schema/constants");
var _app_logic = require("../../../app_logic");
var _engine = require("../../engine");
var _schema_logic = require("../schema_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SchemaTable = () => {
  const {
    myRole: {
      canManageEngines
    }
  } = (0, _kea.useValues)(_app_logic.AppLogic);
  const {
    schema,
    unconfirmedFields,
    incompleteFields
  } = (0, _kea.useValues)(_schema_logic.SchemaLogic);
  const {
    updateSchemaFieldType
  } = (0, _kea.useActions)(_schema_logic.SchemaLogic);
  const {
    isElasticsearchEngine
  } = (0, _kea.useValues)(_engine.EngineLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTable, {
    tableLayout: "auto"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, null, _constants.FIELD_NAME), /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, {
    "aria-hidden": true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, {
    align: "right",
    id: "schemaFieldType"
  }, _constants.FIELD_TYPE)), /*#__PURE__*/_react.default.createElement(_eui.EuiTableBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
    style: {
      height: 56
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("code", null, "id"))), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
    "aria-hidden": true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
    align: "right"
  })), Object.entries(schema).map(([fieldName, fieldType]) => {
    const isRecentlyAdded = unconfirmedFields.includes(fieldName);
    const isMissingSubfields = fieldType === 'text' && incompleteFields.includes(fieldName);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
      key: fieldName
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, null, /*#__PURE__*/_react.default.createElement("code", null, fieldName)), isRecentlyAdded && /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
      align: "right"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: "success"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "s"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.schema.unconfirmedFieldLabel', {
      defaultMessage: 'Recently added'
    })))), isMissingSubfields && /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
      align: "right"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: "warning"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "s"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.schema.missingSubfieldsLabel', {
      defaultMessage: 'Missing subfields'
    })))), !(isRecentlyAdded || isMissingSubfields) && /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
      "aria-hidden": true
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
      align: "right",
      width: 150
    }, /*#__PURE__*/_react.default.createElement(_schema.SchemaFieldTypeSelect, {
      fieldName: fieldName,
      fieldType: fieldType,
      disabled: !canManageEngines || isElasticsearchEngine,
      updateExistingFieldType: updateSchemaFieldType,
      "aria-labelledby": "schemaFieldType"
    })));
  })));
};
exports.SchemaTable = SchemaTable;