"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetaEnginesConflictsTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../shared/schema/constants");
var _engines = require("../../engines");
var _schema_meta_engine_logic = require("../schema_meta_engine_logic");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MetaEnginesConflictsTable = () => {
  const {
    conflictingFields
  } = (0, _kea.useValues)(_schema_meta_engine_logic.MetaEngineSchemaLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTable, {
    tableLayout: "auto"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, null, _constants.FIELD_NAME), /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.schema.metaEngine.fieldTypeConflicts', {
    defaultMessage: 'Field type conflicts'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, null, _engines.ENGINES_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiTableBody, null, Object.entries(conflictingFields).map(([fieldName, conflicts]) => Object.entries(conflicts).map(([fieldType, engines], i) => {
    const isFirstRow = i === 0;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
      key: `${fieldName}-${fieldType}`
    }, isFirstRow && /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
      rowSpan: Object.values(conflicts).length,
      "data-test-subj": "fieldName"
    }, /*#__PURE__*/_react.default.createElement("code", null, fieldName)), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
      "data-test-subj": "fieldTypes"
    }, fieldType), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
      "data-test-subj": "enginesPerFieldType"
    }, /*#__PURE__*/_react.default.createElement(_.TruncatedEnginesList, {
      engines: engines,
      cutoff: 2
    })));
  }))));
};
exports.MetaEnginesConflictsTable = MetaEnginesConflictsTable;