"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryPerformance = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _result_settings_logic = require("../result_settings_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
var QueryPerformanceRating = /*#__PURE__*/function (QueryPerformanceRating) {
  QueryPerformanceRating["Optimal"] = "Optimal";
  QueryPerformanceRating["Good"] = "Good";
  QueryPerformanceRating["Standard"] = "Standard";
  QueryPerformanceRating["Delayed"] = "Delayed";
  return QueryPerformanceRating;
}(QueryPerformanceRating || {});
const QUERY_PERFORMANCE_LABEL = performanceValue => _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.resultSettings.queryPerformanceLabel', {
  defaultMessage: 'Query performance: {performanceValue}',
  values: {
    performanceValue
  }
});
const QUERY_PERFORMANCE_OPTIMAL = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.resultSettings.queryPerformance.optimalValue', {
  defaultMessage: 'optimal'
});
const QUERY_PERFORMANCE_GOOD = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.resultSettings.queryPerformance.goodValue', {
  defaultMessage: 'good'
});
const QUERY_PERFORMANCE_STANDARD = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.resultSettings.queryPerformance.standardValue', {
  defaultMessage: 'standard'
});
const QUERY_PERFORMANCE_DELAYED = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.resultSettings.queryPerformance.delayedValue', {
  defaultMessage: 'delayed'
});
const badgeText = {
  [QueryPerformanceRating.Optimal]: QUERY_PERFORMANCE_LABEL(QUERY_PERFORMANCE_OPTIMAL),
  [QueryPerformanceRating.Good]: QUERY_PERFORMANCE_LABEL(QUERY_PERFORMANCE_GOOD),
  [QueryPerformanceRating.Standard]: QUERY_PERFORMANCE_LABEL(QUERY_PERFORMANCE_STANDARD),
  [QueryPerformanceRating.Delayed]: QUERY_PERFORMANCE_LABEL(QUERY_PERFORMANCE_DELAYED)
};
const badgeColors = {
  [QueryPerformanceRating.Optimal]: '#59deb4',
  [QueryPerformanceRating.Good]: '#40bfff',
  [QueryPerformanceRating.Standard]: '#fed566',
  [QueryPerformanceRating.Delayed]: '#ff9173'
};
const getPerformanceRating = score => {
  switch (true) {
    case score < 6:
      return QueryPerformanceRating.Optimal;
    case score < 11:
      return QueryPerformanceRating.Good;
    case score < 21:
      return QueryPerformanceRating.Standard;
    default:
      return QueryPerformanceRating.Delayed;
  }
};
const QueryPerformance = () => {
  const {
    queryPerformanceScore
  } = (0, _kea.useValues)(_result_settings_logic.ResultSettingsLogic);
  const performanceRating = getPerformanceRating(queryPerformanceScore);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    role: "region",
    "aria-live": "polite",
    color: badgeColors[performanceRating]
  }, badgeText[performanceRating]);
};
exports.QueryPerformance = QueryPerformance;