"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogRetentionMessage = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _log_retention_logic = require("../log_retention_logic");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogRetentionMessage = ({
  type
}) => {
  var _logRetentionSettings;
  const {
    logRetention
  } = (0, _kea.useValues)(_log_retention_logic.LogRetentionLogic);
  if (!logRetention) return null;
  const logRetentionSettings = logRetention[type];
  if (!logRetentionSettings) return null;
  if (!logRetentionSettings.enabled) {
    return /*#__PURE__*/_react.default.createElement(_constants.NoLogging, {
      type: type,
      disabledAt: logRetentionSettings.disabledAt
    });
  }
  if (!((_logRetentionSettings = logRetentionSettings.retentionPolicy) !== null && _logRetentionSettings !== void 0 && _logRetentionSettings.isDefault)) {
    return /*#__PURE__*/_react.default.createElement(_constants.CustomPolicy, {
      type: type
    });
  } else {
    var _logRetentionSettings2;
    return /*#__PURE__*/_react.default.createElement(_constants.DefaultPolicy, {
      type: type,
      minAgeDays: (_logRetentionSettings2 = logRetentionSettings.retentionPolicy) === null || _logRetentionSettings2 === void 0 ? void 0 : _logRetentionSettings2.minAgeDays
    });
  }
};
exports.LogRetentionMessage = LogRetentionMessage;