"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppSearchPageTemplate = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _constants = require("../../../../../common/constants");
var _deprecation_callout = require("../../../shared/deprecation_callout/deprecation_callout");
var _doc_links = require("../../../shared/doc_links");
var _kibana = require("../../../shared/kibana");
var _kibana_chrome = require("../../../shared/kibana_chrome");
var _layout = require("../../../shared/layout");
var _telemetry = require("../../../shared/telemetry");
var _nav = require("./nav");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AppSearchPageTemplate = ({
  children,
  pageChrome,
  pageViewTelemetry,
  ...pageTemplateProps
}) => {
  const navItems = (0, _nav.useAppSearchNav)();
  const {
    getChromeStyle$,
    updateSideNavDefinition
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const chromeStyle = (0, _useObservable.default)(getChromeStyle$(), 'classic');
  _react.default.useEffect(() => {
    var _navItems$;
    if (chromeStyle === 'classic') return;
    const appSearch = (0, _nav.cleanAppSearchNavItems)(navItems === null || navItems === void 0 ? void 0 : (_navItems$ = navItems[0]) === null || _navItems$ === void 0 ? void 0 : _navItems$.items);
    // We update the new side nav definition with the selected app items
    updateSideNavDefinition({
      appSearch
    });
    return () => {
      updateSideNavDefinition({
        appSearch: undefined
      });
    };
  }, [chromeStyle, navItems, updateSideNavDefinition]);
  const [showDeprecationCallout, setShowDeprecationCallout] = _react.default.useState(!sessionStorage.getItem('appSearchHideDeprecationCallout'));
  const onDismissDeprecationCallout = () => {
    setShowDeprecationCallout(false);
    sessionStorage.setItem('appSearchHideDeprecationCallout', 'true');
  };
  return /*#__PURE__*/_react.default.createElement(_layout.EnterpriseSearchPageTemplateWrapper, (0, _extends2.default)({}, pageTemplateProps, {
    solutionNav: {
      name: _constants.APP_SEARCH_PLUGIN.NAME,
      items: chromeStyle === 'classic' ? navItems : undefined
    },
    setPageChrome: pageChrome && /*#__PURE__*/_react.default.createElement(_kibana_chrome.SetAppSearchChrome, {
      trail: pageChrome
    }),
    useEndpointHeaderActions: false,
    hideEmbeddedConsole: true
  }), pageViewTelemetry && /*#__PURE__*/_react.default.createElement(_telemetry.SendAppSearchTelemetry, {
    action: "viewed",
    metric: pageViewTelemetry
  }), showDeprecationCallout ? /*#__PURE__*/_react.default.createElement(_deprecation_callout.EnterpriseSearchDeprecationCallout, {
    onDismissAction: onDismissDeprecationCallout,
    learnMoreLinkUrl: _doc_links.docLinks.appSearchGuide
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null), children);
};
exports.AppSearchPageTemplate = AppSearchPageTemplate;