"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AuditLogsModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../../../common/constants");
var _log_stream = require("../../../../../shared/log_stream");
var _audit_logs_modal_logic = require("./audit_logs_modal_logic");
require("./audit_logs_modal.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AuditLogsModal = () => {
  const auditLogsModalLogic = (0, _audit_logs_modal_logic.AuditLogsModalLogic)();
  const {
    isModalVisible,
    engineName
  } = (0, _kea.useValues)(auditLogsModalLogic);
  const {
    hideModal
  } = (0, _kea.useActions)(auditLogsModalLogic);
  const filters = ['event.kind: event', 'event.action: audit', `enterprisesearch.data_repository.name: ${engineName}`].join(' and ');
  return !isModalVisible ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: hideModal,
    className: "auditLogsModal",
    maxWidth: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, engineName)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engines.auditLogsModal.eventTip', {
    defaultMessage: 'Showing events from last 24 hours'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_log_stream.EntSearchLogStream, {
    logView: {
      type: 'log-view-reference',
      logViewId: _constants.ENTERPRISE_SEARCH_AUDIT_LOGS_SOURCE_ID
    },
    columns: [{
      type: 'timestamp'
    }, {
      type: 'field',
      field: 'user.id',
      header: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engines.auditLogsModal.headers.updatedBy', {
        defaultMessage: 'Updated By'
      })
    }, {
      type: 'field',
      field: 'event.category',
      header: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engines.auditLogsModal.headers.eventCategory', {
        defaultMessage: 'Event Category'
      })
    }, {
      type: 'field',
      field: 'event.type',
      header: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engines.auditLogsModal.headers.eventType', {
        defaultMessage: 'Event Type'
      })
    }, {
      type: 'field',
      field: 'event.outcome',
      header: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engines.auditLogsModal.headers.outcome', {
        defaultMessage: 'Outcome'
      })
    }, {
      type: 'field',
      field: 'message',
      width: '50%'
    }],
    query: filters
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: hideModal,
    fill: true
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engines.auditLogsModal.closeButton', {
    defaultMessage: 'Close'
  }))));
};
exports.AuditLogsModal = AuditLogsModal;