"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultiCheckboxFacetsView = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getIndexFromId = id => parseInt(id.split('_')[1], 10);
const MultiCheckboxFacetsView = ({
  label,
  onMoreClick,
  onRemove,
  onSelect,
  options,
  showMore
}) => {
  const getId = (0, _eui.htmlIdGenerator)();
  const optionToCheckBoxGroupOption = (option, index) => ({
    id: getId(String(index)),
    label: option.value || _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documents.search.multiCheckboxFacetsView.noValue.selectOption', {
      defaultMessage: '<No value>',
      ignoreTag: true
    })
  });
  const optionToSelectedMapReducer = (selectedMap, option, index) => {
    if (option.selected) {
      selectedMap[getId(String(index))] = true;
    }
    return selectedMap;
  };
  const checkboxGroupOptions = options.map(optionToCheckBoxGroupOption);
  const idToSelectedMap = options.reduce(optionToSelectedMapReducer, {});
  const onChange = checkboxId => {
    const index = getIndexFromId(checkboxId);
    const option = options[index];
    if (option.selected) {
      onRemove(option.value);
      return;
    }
    onSelect(option.value);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckboxGroup, {
    "data-test-subj": "checkbox-group",
    className: "documentsSearchExperience__facet",
    legend: {
      children: label
    },
    options: checkboxGroupOptions,
    idToSelectedMap: idToSelectedMap,
    onChange: onChange
  }), showMore && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "more",
    onClick: onMoreClick,
    iconSide: "right",
    iconType: "arrowDown",
    size: "xs"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documents.search.multiCheckboxFacetsView.showMore', {
    defaultMessage: 'Show more'
  })))));
};
exports.MultiCheckboxFacetsView = MultiCheckboxFacetsView;