"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildSortOptions = void 0;
var _lodash = require("lodash");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fieldNameToSortOptions = fieldName => ['asc', 'desc'].map(direction => ({
  name: direction === 'asc' ? (0, _constants.ASCENDING)(fieldName) : (0, _constants.DESCENDING)(fieldName),
  value: fieldName,
  direction: direction
}));

/**
 * Adds two sort options for a given field, a "desc" and an "asc" option.
 */
const buildSortOptions = (fields, defaultSortOptions) => {
  const sortFieldsOptions = (0, _lodash.flatten)(fields.sortFields.map(fieldNameToSortOptions));
  const sortingOptions = [...defaultSortOptions, ...sortFieldsOptions];
  return sortingOptions;
};
exports.buildSortOptions = buildSortOptions;