"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManualCuration = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _layout = require("../../layout");
var _constants = require("../constants");
var _utils = require("../utils");
var _constants2 = require("./constants");
var _curation_logic = require("./curation_logic");
var _delete_curation_button = require("./delete_curation_button");
var _documents = require("./documents");
var _queries = require("./queries");
var _results = require("./results");
var _suggested_documents_callout = require("./suggested_documents_callout");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ManualCuration = () => {
  const {
    curationId
  } = (0, _reactRouterDom.useParams)();
  const logic = (0, _curation_logic.CurationLogic)({
    curationId
  });
  const {
    onSelectPageTab
  } = (0, _kea.useActions)(logic);
  const {
    queries,
    selectedPageTab,
    curation
  } = (0, _kea.useValues)(logic);
  const {
    isFlyoutOpen
  } = (0, _kea.useValues)(_results.AddResultLogic);
  const pageTabs = [{
    label: _constants2.PROMOTED_DOCUMENTS_TITLE,
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, curation.promoted.length),
    isSelected: selectedPageTab === 'promoted',
    onClick: () => onSelectPageTab('promoted')
  }, {
    label: _constants2.HIDDEN_DOCUMENTS_TITLE,
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, curation.hidden.length),
    isSelected: selectedPageTab === 'hidden',
    onClick: () => onSelectPageTab('hidden')
  }];
  return /*#__PURE__*/_react.default.createElement(_layout.AppSearchPageTemplate, {
    pageChrome: (0, _utils.getCurationsBreadcrumbs)([queries.join(', ')]),
    pageHeader: {
      pageTitle: _constants.MANAGE_CURATION_TITLE,
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        responsive: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_delete_curation_button.DeleteCurationButton, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_queries.ManageQueriesModal, null)))],
      tabs: pageTabs
    }
  }, /*#__PURE__*/_react.default.createElement(_queries.ActiveQuerySelect, null), selectedPageTab === 'promoted' && /*#__PURE__*/_react.default.createElement(_suggested_documents_callout.SuggestedDocumentsCallout, null), selectedPageTab === 'promoted' && /*#__PURE__*/_react.default.createElement(_documents.PromotedDocuments, null), selectedPageTab === 'hidden' && /*#__PURE__*/_react.default.createElement(_documents.HiddenDocuments, null), /*#__PURE__*/_react.default.createElement(_documents.OrganicDocuments, null), isFlyoutOpen && /*#__PURE__*/_react.default.createElement(_results.AddResultFlyout, null));
};
exports.ManualCuration = ManualCuration;