"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PromotedDocuments = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _data_panel = require("../../../data_panel");
var _constants = require("../../constants");
var _constants2 = require("../constants");
var _curation_logic = require("../curation_logic");
var _results = require("../results");
require("./promoted_documents.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PromotedDocuments = () => {
  const {
    curation,
    isAutomated,
    promotedIds,
    promotedDocumentsLoading
  } = (0, _kea.useValues)(_curation_logic.CurationLogic);
  const documents = curation.promoted;
  const hasDocuments = documents.length > 0;
  const {
    setPromotedIds,
    clearPromotedIds,
    removePromotedId
  } = (0, _kea.useActions)(_curation_logic.CurationLogic);
  const reorderPromotedIds = ({
    source,
    destination
  }) => {
    if (source && destination) {
      const reorderedIds = (0, _eui.euiDragDropReorder)(promotedIds, source.index, destination.index);
      setPromotedIds(reorderedIds);
    }
  };
  const CountBadge = () => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "accent"
  }, documents.length);
  return /*#__PURE__*/_react.default.createElement(_data_panel.DataPanel, {
    iconType: CountBadge,
    title: /*#__PURE__*/_react.default.createElement("h2", null, _constants2.PROMOTED_DOCUMENTS_TITLE),
    action: isAutomated ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement("em", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.promotedDocuments.managedByAppSearchDescription', {
      defaultMessage: 'This curation is being automated by App Search'
    })))) : hasDocuments && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      responsive: false,
      wrap: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: clearPromotedIds,
      color: "danger",
      size: "s",
      disabled: isAutomated
    }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.promotedDocuments.removeAllButtonLabel', {
      defaultMessage: 'Demote all'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_results.AddResultButton, null))),
    isLoading: promotedDocumentsLoading
  }, hasDocuments ? /*#__PURE__*/_react.default.createElement(_eui.EuiDragDropContext, {
    onDragEnd: reorderPromotedIds
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDroppable, {
    droppableId: "PromotedDocuments",
    spacing: "m",
    className: "promotedDocuments--results"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, documents.map((document, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: index
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDraggable, {
    index: index,
    draggableId: document.id,
    customDragHandle: true,
    spacing: "none",
    isDragDisabled: isAutomated
  }, provided => /*#__PURE__*/_react.default.createElement(_results.CurationResult, {
    index: index,
    result: (0, _results.convertToResultFormat)(document),
    actions: isAutomated ? [] : [{
      ..._constants.DEMOTE_DOCUMENT_ACTION,
      onClick: () => removePromotedId(document.id)
    }],
    dragHandleProps: provided.dragHandleProps
  }))))))) : /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    body: isAutomated ? _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.promotedDocuments.automatedEmptyDescription', {
      defaultMessage: "We haven't identified any documents to promote"
    }) : _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.promotedDocuments.emptyDescription', {
      defaultMessage: 'Star documents from the organic results below, or search and promote a result manually.'
    }),
    actions: /*#__PURE__*/_react.default.createElement(_results.AddResultButton, null)
  }));
};
exports.PromotedDocuments = PromotedDocuments;