"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AutomatedCuration = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _engine = require("../../engine");
var _layout = require("../../layout");
var _automated_icon = require("../components/automated_icon");
var _constants = require("../constants");
var _utils = require("../utils");
var _automated_curation_history = require("./automated_curation_history");
var _constants2 = require("./constants");
var _curation_logic = require("./curation_logic");
var _delete_curation_button = require("./delete_curation_button");
var _documents = require("./documents");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AutomatedCuration = () => {
  const {
    curationId
  } = (0, _reactRouterDom.useParams)();
  const logic = (0, _curation_logic.CurationLogic)({
    curationId
  });
  const {
    convertToManual,
    onSelectPageTab
  } = (0, _kea.useActions)(logic);
  const {
    activeQuery,
    queries,
    curation,
    selectedPageTab
  } = (0, _kea.useValues)(logic);
  const {
    engineName
  } = (0, _kea.useValues)(_engine.EngineLogic);
  const pageTabs = [{
    label: _constants2.PROMOTED_DOCUMENTS_TITLE,
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, curation.promoted.length),
    isSelected: selectedPageTab === 'promoted',
    onClick: () => onSelectPageTab('promoted')
  }, {
    label: _constants2.HIDDEN_DOCUMENTS_TITLE,
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      isDisabled: true
    }, "0"),
    isSelected: false,
    disabled: true
  }, {
    label: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curation.detail.historyButtonLabel', {
      defaultMessage: 'History'
    }),
    isSelected: selectedPageTab === 'history',
    onClick: () => onSelectPageTab('history')
  }];
  return /*#__PURE__*/_react.default.createElement(_layout.AppSearchPageTemplate, {
    pageChrome: (0, _utils.getCurationsBreadcrumbs)([queries.join(', ')]),
    pageHeader: {
      pageTitle: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, activeQuery, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        iconType: _automated_icon.AutomatedIcon,
        color: "accent"
      }, _constants.AUTOMATED_LABEL)),
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        responsive: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_delete_curation_button.DeleteCurationButton, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        color: "primary",
        fill: true,
        iconType: "exportAction",
        onClick: () => {
          if (window.confirm(_constants.CONVERT_TO_MANUAL_CONFIRMATION)) convertToManual();
        }
      }, _constants.COVERT_TO_MANUAL_BUTTON_LABEL)))],
      tabs: pageTabs
    }
  }, selectedPageTab === 'promoted' && /*#__PURE__*/_react.default.createElement(_documents.PromotedDocuments, null), selectedPageTab === 'promoted' && /*#__PURE__*/_react.default.createElement(_documents.OrganicDocuments, null), selectedPageTab === 'history' && /*#__PURE__*/_react.default.createElement(_automated_curation_history.AutomatedCurationHistory, {
    query: curation.queries[0],
    engineName: engineName
  }));
};
exports.AutomatedCuration = AutomatedCuration;