"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CrawlDetailsSummary = void 0;
var _react = _interopRequireDefault(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CrawlDetailsSummary = ({
  crawlDepth,
  crawlType,
  crawlerLogsEnabled,
  domainCount,
  stats
}) => {
  const duration = () => {
    if (stats && stats.status && stats.status.crawlDurationMSec) {
      const milliseconds = _moment.default.duration(stats.status.crawlDurationMSec, 'milliseconds');
      const days = milliseconds.days();
      const hours = milliseconds.hours();
      const minutes = milliseconds.minutes();
      const seconds = milliseconds.seconds();
      return `${days ? days + 'd ' : ''}${hours}h ${minutes}m ${seconds}s`;
    } else {
      return '--';
    }
  };
  const getStatusCount = (code, codes) => {
    return Object.entries(codes).reduce((count, [k, v]) => {
      if (k[0] !== code) return count;
      return v + count;
    }, 0);
  };
  const statusCounts = {
    clientErrorCount: stats && stats.status && stats.status.statusCodes ? getStatusCount('4', stats.status.statusCodes) : 0,
    serverErrorCount: stats && stats.status && stats.status.statusCodes ? getStatusCount('5', stats.status.statusCodes) : 0
  };
  const shouldHideStats = !crawlerLogsEnabled && !stats;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "l",
    color: "primary"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subjet": "crawlType",
    titleSize: "s",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.components.crawlDetailsSummary.crawlCountOnDomains', {
      defaultMessage: '{crawlType} crawl on {domainCount, plural, one {# domain} other {# domains}}',
      values: {
        crawlType: crawlType[0].toUpperCase() + crawlType.substring(1),
        domainCount
      }
    }),
    description: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.components.crawlDetailsSummary.crawlTypeLabel', {
      defaultMessage: 'Crawl type'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": "crawlDepth",
    titleSize: "s",
    title: crawlDepth,
    description: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.components.crawlDetailsSummary.crawlDepthLabel', {
      defaultMessage: 'Max crawl depth'
    })
  })), !shouldHideStats && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": "crawlDuration",
    titleSize: "s",
    title: duration(),
    description: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlDetailsSummary.durationTooltipTitle', {
      defaultMessage: 'Duration'
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }), !shouldHideStats ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": "urlsAllowed",
    titleSize: "s",
    title: stats && stats.status && stats.status.urlsAllowed ? stats.status.urlsAllowed : '--',
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, "URLs", ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      type: "iInCircle",
      color: "primary",
      size: "m",
      title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlDetailsSummary.urlsTooltipTitle', {
        defaultMessage: 'URLs Seen'
      }),
      content: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlDetailsSummary.urlsTooltip', {
        defaultMessage: 'URLs found by the crawler during the crawl, including those not followed due to the crawl configuration.'
      })
    }))
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": "pagesVisited",
    titleSize: "s",
    title: stats && stats.status && stats.status.pagesVisited ? stats.status.pagesVisited : '--',
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlDetailsSummary.pagesVisitedTooltipTitle', {
      defaultMessage: 'Pages'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      type: "iInCircle",
      color: "primary",
      size: "m",
      title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlDetailsSummary.pagesTooltipTitle', {
        defaultMessage: 'Pages visited'
      }),
      content: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlDetailsSummary.pagesTooltip', {
        defaultMessage: 'URLs visited and extracted during the crawl.'
      })
    }))
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": "avgResponseTime",
    titleSize: "s",
    title: stats && stats.status && stats.status.avgResponseTimeMSec ? `${Math.round(stats.status.avgResponseTimeMSec)}ms` : '--',
    description: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlDetailsSummary.avgResponseTimeLabel', {
      defaultMessage: 'Avg. response'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": "clientErrors",
    titleSize: "s",
    title: statusCounts.clientErrorCount,
    description: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlDetailsSummary.clientErrorsLabel', {
      defaultMessage: '4xx Errors'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": "serverErrors",
    titleSize: "s",
    title: statusCounts.serverErrorCount,
    description: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlDetailsSummary.serverErrorsLabel', {
      defaultMessage: '5xx Errors'
    })
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    textAlign: "center",
    "data-test-subj": "logsDisabledMessage"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlDetailsSummary.logsDisabledMessage', {
    defaultMessage: 'Enable Web Crawler logs in settings for more detailed crawl statistics.'
  }))));
};
exports.CrawlDetailsSummary = CrawlDetailsSummary;