"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sendAppSearchGatedFormData = exports.UpdateAppSearchGatedFormDataApiLogic = void 0;
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sendAppSearchGatedFormData = async ({
  feature,
  featuresOther,
  additionalFeedback,
  participateInUXLabs
}) => {
  return await _http.HttpLogic.values.http.post('/internal/app_search/as_gate', {
    body: JSON.stringify({
      as_gate_data: {
        additional_feedback: additionalFeedback != null ? additionalFeedback : undefined,
        feature,
        features_other: featuresOther != null ? featuresOther : undefined,
        participate_in_ux_labs: participateInUXLabs != null ? participateInUXLabs : undefined
      }
    })
  });
};
exports.sendAppSearchGatedFormData = sendAppSearchGatedFormData;
const UpdateAppSearchGatedFormDataApiLogic = exports.UpdateAppSearchGatedFormDataApiLogic = (0, _create_api_logic.createApiLogic)(['app_search', 'send_app_search_gatedForm_data_api_logic'], sendAppSearchGatedFormData);