"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyticsCollectionTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _get_formula_by_filter = require("../../utils/get_formula_by_filter");
var _add_analytics_collection = require("../add_analytics_collections/add_analytics_collection");
var _analytics_collection_card = require("./analytics_collection_card/analytics_collection_card");
var _analytics_collection_not_found = require("./analytics_collection_not_found");
var _analytics_collection_table = require("./analytics_collection_table.styles");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultQuickRanges = [{
  end: 'now',
  label: _i18n.i18n.translate('xpack.enterpriseSearch.analytics..units.quickRange.last7Days', {
    defaultMessage: 'Last 7 days'
  }),
  start: 'now-7d'
}, {
  end: 'now',
  label: _i18n.i18n.translate('xpack.enterpriseSearch.analytics..units.quickRange.last2Weeks', {
    defaultMessage: 'Last 2 weeks'
  }),
  start: 'now-14d'
}, {
  end: 'now',
  label: _i18n.i18n.translate('xpack.enterpriseSearch.analytics..units.quickRange.last30Days', {
    defaultMessage: 'Last 30 days'
  }),
  start: 'now-30d'
}, {
  end: 'now',
  label: _i18n.i18n.translate('xpack.enterpriseSearch.analytics..units.quickRange.last90Days', {
    defaultMessage: 'Last 90 days'
  }),
  start: 'now-90d'
}, {
  end: 'now',
  label: _i18n.i18n.translate('xpack.enterpriseSearch.analytics..units.quickRange.last1Year', {
    defaultMessage: 'Last 1 year'
  }),
  start: 'now-1y'
}];
const AnalyticsCollectionTable = ({
  collections,
  isSearching,
  onSearch
}) => {
  var _filterOptions$find;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const analyticsCollectionTableStyles = (0, _analytics_collection_table.AnalyticsCollectionTableStyles)(euiTheme);
  const filterOptions = (0, _react.useMemo)(() => [{
    css: [analyticsCollectionTableStyles.button],
    id: _get_formula_by_filter.FilterBy.Searches,
    label: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.filtering.searches', {
      defaultMessage: 'Searches'
    })
  }, {
    css: [analyticsCollectionTableStyles.button],
    id: _get_formula_by_filter.FilterBy.NoResults,
    label: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.filtering.noResults', {
      defaultMessage: 'No results'
    })
  }, {
    css: [analyticsCollectionTableStyles.button],
    id: _get_formula_by_filter.FilterBy.Clicks,
    label: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.filtering.clicks', {
      defaultMessage: 'Clicks'
    })
  }, {
    css: [analyticsCollectionTableStyles.button],
    id: _get_formula_by_filter.FilterBy.Sessions,
    label: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.filtering.sessions', {
      defaultMessage: 'Sessions'
    })
  }], [analyticsCollectionTableStyles.button]);
  const [filterId, setFilterId] = (0, _react.useState)(filterOptions[0].id);
  const [query, setQuery] = (0, _react.useState)('');
  const [timeRange, setTimeRange] = (0, _react.useState)({
    from: defaultQuickRanges[0].start,
    to: defaultQuickRanges[0].end
  });
  const handleTimeChange = ({
    start,
    end
  }) => {
    setTimeRange({
      from: start,
      to: end
    });
  };
  const selectedFilterLabel = (_filterOptions$find = filterOptions.find(({
    id
  }) => id === filterId)) === null || _filterOptions$find === void 0 ? void 0 : _filterOptions$find.label;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    borderRadius: "none",
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    placeholder: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.searchPlaceholder', {
      defaultMessage: 'Search collection names'
    }),
    value: query,
    onChange: e => {
      setQuery(e.target.value);
    },
    isLoading: isSearching,
    onSearch: onSearch,
    incremental: true,
    fullWidth: true
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    "data-test-subj": "enterpriseSearchAnalyticsCollectionTableButtonGroup",
    css: analyticsCollectionTableStyles.buttonGroup,
    onChange: newFilterId => setFilterId(newFilterId),
    color: "primary",
    buttonSize: "compressed",
    idSelected: filterId,
    isFullWidth: true,
    options: filterOptions,
    legend: "Filter Collection"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, {
    start: timeRange.from,
    end: timeRange.to,
    onTimeChange: handleTimeChange,
    showUpdateButton: false,
    width: "full",
    commonlyUsedRanges: defaultQuickRanges
  })))), collections.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 3
  }, collections.map(collection => /*#__PURE__*/_react.default.createElement(_analytics_collection_card.AnalyticsCollectionCardWithLens, {
    key: collection.name,
    id: `collection-card-${collection.name}`,
    collection: collection,
    subtitle: selectedFilterLabel,
    filterBy: filterId,
    timeRange: timeRange
  }))) : /*#__PURE__*/_react.default.createElement(_analytics_collection_not_found.AnalyticsCollectionNotFound, {
    query: query
  }), /*#__PURE__*/_react.default.createElement(_add_analytics_collection.AddAnalyticsCollection, {
    render: onClick => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconType: "plusInCircleFilled",
      css: analyticsCollectionTableStyles.newCollection,
      onClick: onClick
    }, _i18n.i18n.translate('xpack.enterpriseSearch.analytics.createNewCollection', {
      defaultMessage: 'Create new collection'
    }))
  }));
};
exports.AnalyticsCollectionTable = AnalyticsCollectionTable;