"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElserPanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../common/constants");
var _doc_links = require("../../../shared/doc_links");
var _http = require("../../../shared/http");
var _kibana = require("../../../shared/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ElserPanel = () => {
  const {
    http
  } = (0, _kea.useValues)(_http.HttpLogic);
  const {
    application
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.aiSearch.elser.description",
    defaultMessage: "The {elser} enables textual semantic search over your Elasticsearch documents in just a few commands. Use the 'semantic_text' field to simplify model deployment and generate sparse vector document embeddings.",
    values: {
      elser: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "enterpriseSearchElserPanelElasticLearnedSparseEncoderV2Link",
        target: "_blank",
        href: _doc_links.docLinks.elser,
        external: false
      }, _i18n.i18n.translate('xpack.enterpriseSearch.aiSearch.elser.description.elserLinkText', {
        defaultMessage: 'Elastic Learned Sparse Encoder v2'
      }))
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "enterpriseSearchElserPanelLink",
    onClick: () => {
      application.navigateToUrl(http.basePath.prepend(`${_constants.SEMANTIC_SEARCH_PLUGIN.URL}?model_example=elser`));
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "enterpriseSearchElserPanelSetupSemanticSearchButton",
    "data-telemetry-id": "entSearch-aiSearch-semanticSearch-elserPanel-setupSemanticSearch"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.aiSearch.elserPanel.buttonLabel', {
    defaultMessage: 'Set up Semantic Search'
  }))))));
};
exports.ElserPanel = ElserPanel;