"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertsTableEmbeddableFactory = void 0;
var _react = _interopRequireDefault(require("react"));
var _rxjs = require("rxjs");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _reactQuery = require("@tanstack/react-query");
var _public = require("@kbn/kibana-react-plugin/public");
var _presentationContainers = require("@kbn/presentation-containers");
var _solutions = require("@kbn/response-ops-alerts-filters-form/utils/solutions");
var _get_internal_rule_types_with_cache = require("../utils/get_internal_rule_types_with_cache");
var _translations = require("../translations");
var _open_config_editor = require("../components/open_config_editor");
var _constants = require("../constants");
var _embeddable_alerts_table = require("../components/embeddable_alerts_table");
var _query_client = require("../query_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAlertsTableEmbeddableFactory = (coreServices, deps) => ({
  type: _constants.EMBEDDABLE_ALERTS_TABLE_ID,
  buildEmbeddable: async ({
    initialState,
    finalizeApi,
    parentApi,
    uuid
  }) => {
    var _initialState$rawStat;
    const timeRangeManager = (0, _presentationPublishing.initializeTimeRangeManager)(initialState === null || initialState === void 0 ? void 0 : initialState.rawState);
    const titleManager = (0, _presentationPublishing.initializeTitleManager)((_initialState$rawStat = initialState === null || initialState === void 0 ? void 0 : initialState.rawState) !== null && _initialState$rawStat !== void 0 ? _initialState$rawStat : {});
    const queryLoading$ = new _rxjs.BehaviorSubject(true);
    const services = {
      ...coreServices,
      ...deps
    };
    const currentTableConfig = initialState.rawState.tableConfig;
    const tableConfig$ = new _rxjs.BehaviorSubject(currentTableConfig);
    const serializeState = () => ({
      rawState: {
        ...titleManager.getLatestState(),
        ...timeRangeManager.getLatestState(),
        tableConfig: tableConfig$.getValue()
      }
    });
    const unsavedChangesApi = (0, _presentationContainers.initializeUnsavedChanges)({
      uuid,
      parentApi,
      anyStateChange$: (0, _rxjs.merge)(timeRangeManager.anyStateChange$, titleManager.anyStateChange$, tableConfig$).pipe((0, _rxjs.map)(() => undefined)),
      serializeState,
      getComparators: () => ({
        ..._presentationPublishing.titleComparators,
        ..._presentationPublishing.timeRangeComparators,
        tableConfig: 'deepEquality'
      }),
      onReset: lastSaved => {
        titleManager.reinitializeState(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState);
        timeRangeManager.reinitializeState(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState);
      }
    });
    const ruleTypes = await (0, _get_internal_rule_types_with_cache.getInternalRuleTypesWithCache)(coreServices.http);
    const ruleTypeIdsForSolution = !ruleTypes || !(currentTableConfig !== null && currentTableConfig !== void 0 && currentTableConfig.solution) ? [] : (0, _solutions.getRuleTypeIdsForSolution)(ruleTypes, currentTableConfig.solution);
    const api = finalizeApi({
      ...timeRangeManager.api,
      ...titleManager.api,
      ...unsavedChangesApi,
      dataLoading$: queryLoading$,
      serializeState,
      isEditingEnabled: () => {
        // Users cannot edit panels based on a solution they cannot access.
        // The first condition ensures panels are editable even if the table configuration is
        // unexpectedly undefined or incomplete
        return !(currentTableConfig !== null && currentTableConfig !== void 0 && currentTableConfig.solution) || ruleTypeIdsForSolution.length > 0;
      },
      getTypeDisplayName: () => _translations.ALERTS_PANEL_LABEL,
      onEdit: async () => {
        try {
          const newTableConfig = await (0, _open_config_editor.openConfigEditor)({
            coreServices,
            parentApi: api.parentApi,
            initialConfig: tableConfig$.getValue()
          });
          tableConfig$.next(newTableConfig);
        } catch {
          // The user closed without saving, discard the edits
        }
      }
    });
    return {
      api,
      Component: () => {
        const {
          timeRange: selectedTimeRange
        } = (0, _presentationPublishing.useFetchContext)(api);
        const tableConfig = (0, _presentationPublishing.useStateFromPublishingSubject)(tableConfig$);
        return /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
          services: services
        }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
          client: _query_client.queryClient
        }, /*#__PURE__*/_react.default.createElement(_embeddable_alerts_table.EmbeddableAlertsTable, {
          id: `${_constants.PERSISTED_TABLE_CONFIG_KEY_PREFIX}-${uuid}`,
          timeRange: selectedTimeRange,
          solution: tableConfig === null || tableConfig === void 0 ? void 0 : tableConfig.solution,
          query: tableConfig === null || tableConfig === void 0 ? void 0 : tableConfig.query,
          services: services
        })));
      }
    };
  }
});
exports.getAlertsTableEmbeddableFactory = getAlertsTableEmbeddableFactory;