"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddableAlertsTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _filters = require("@kbn/response-ops-alerts-filters-form/utils/filters");
var _solutions = require("@kbn/response-ops-alerts-filters-form/utils/solutions");
var _use_get_internal_rule_types_query = require("@kbn/response-ops-rules-apis/hooks/use_get_internal_rule_types_query");
var _common = require("@kbn/data-plugin/common");
var _responseOpsAlertsTable = require("@kbn/response-ops-alerts-table");
var _alert_actions_cell = require("@kbn/response-ops-alerts-table/components/alert_actions_cell");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _configuration = require("@kbn/response-ops-alerts-table/configuration");
var _translations = require("../translations");
var _constants = require("../constants");
var _in_memory_storage = require("../utils/in_memory_storage");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const inMemoryStorage = new _in_memory_storage.InMemoryStorage();
const columns = _configuration.defaultAlertsTableColumns.map(column => ({
  ...column,
  actions: false,
  isResizable: false,
  isSortable: false,
  cellActions: []
}));

/**
 * Renders the AlertsTable based on the embeddable table config
 */
const EmbeddableAlertsTable = ({
  id,
  timeRange,
  solution,
  query,
  services
}) => {
  const {
    data: ruleTypes,
    isLoading: isLoadingRuleTypes,
    isError: cannotLoadRuleTypes
  } = (0, _use_get_internal_rule_types_query.useGetInternalRuleTypesQuery)({
    http: services.http
  });
  const ruleTypeIds = (0, _react.useMemo)(() => !ruleTypes || !solution ? [] : (0, _solutions.getRuleTypeIdsForSolution)(ruleTypes, solution), [ruleTypes, solution]);
  const timeRangeQuery = timeRange ? {
    bool: {
      minimum_should_match: 1,
      should: [(0, _common.getTime)(undefined, timeRange, {
        fieldName: _ruleDataUtils.ALERT_TIME_RANGE
      }).query, (0, _common.getTime)(undefined, timeRange, {
        fieldName: _ruleDataUtils.TIMESTAMP
      }).query]
    }
  } : null;
  const filtersQuery = (0, _react.useMemo)(() => {
    let filters = null;
    try {
      if (query !== null && query !== void 0 && query.filters) {
        filters = (0, _filters.alertsFiltersToEsQuery)(query.filters);
      }
    } catch (e) {
      services.notifications.toasts.addError(e, {
        title: _translations.CONFIG_EDITOR_KQL_ERROR_TOAST_TITLE
      });
    }
    return filters;
  }, [query === null || query === void 0 ? void 0 : query.filters, services.notifications.toasts]);
  const finalQuery = {
    bool: {
      must: [timeRangeQuery, filtersQuery].filter(Boolean)
    }
  };
  if (isLoadingRuleTypes) {
    // Using EuiLoadingChart instead of EuiLoadingSpinner to match the
    // dashboard panel loading indicator
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      justifyContent: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
      size: "l"
    })));
  }
  if (cannotLoadRuleTypes) {
    // If rule types are not available, we cannot forward their ids to the table for authorization
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      title: /*#__PURE__*/_react.default.createElement("h2", null, _translations.RULE_TYPES_LOAD_ERROR_TITLE),
      body: /*#__PURE__*/_react.default.createElement("p", null, _translations.RULE_TYPES_LOAD_ERROR_DESCRIPTION),
      color: "danger",
      iconType: "error"
    });
  }
  if (solution && !ruleTypeIds.length) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      title: /*#__PURE__*/_react.default.createElement("h2", null, _translations.NO_AUTHORIZED_RULE_TYPE_PROMPT_TITLE),
      body: /*#__PURE__*/_react.default.createElement("p", null, (0, _translations.getSolutionRuleTypesAuthPromptBody)(solution)),
      iconType: "securityApp",
      "data-test-subj": _constants.NO_AUTHORIZED_RULE_TYPE_PROMPT_SUBJ
    });
  }
  return /*#__PURE__*/_react.default.createElement(_responseOpsAlertsTable.AlertsTable, {
    id: id,
    ruleTypeIds: ruleTypeIds,
    query: finalQuery,
    columns: columns,
    showAlertStatusWithFlapping: true,
    renderActionsCell: _alert_actions_cell.AlertActionsCell,
    toolbarVisibility: {
      // Disabling the fullscreen toggle since it breaks in Dashboards
      // and panels can be maximized on their own
      showFullScreenSelector: false,
      // Disable data grid customizations
      showColumnSelector: false,
      showSortSelector: false,
      showKeyboardShortcuts: false,
      showDisplaySelector: false
    },
    emptyState: {
      height: 'flex',
      variant: 'transparent'
    },
    openLinksInNewTab: true,
    flyoutOwnsFocus: true,
    flyoutPagination: false
    // Saves the configuration in memory in case we want to add a shared configuration saved in
    // the panel config in the future (and avoid localStorage migrations or deletions tasks)
    ,
    configurationStorage: inMemoryStorage
    // Disable columns customziation
    ,
    browserFields: {},
    services: services
  });
};
exports.EmbeddableAlertsTable = EmbeddableAlertsTable;