"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleGraphError = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _helpers = require("../../../helpers/helpers");
var _telemetry = require("../../../helpers/telemetry");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const handleGraphError = async ({
  apiConfig,
  executionUuid,
  authenticatedUser,
  dataClient,
  err,
  latestReplacements,
  logger,
  telemetry
}) => {
  try {
    logger.error(err);
    const error = (0, _securitysolutionEsUtils.transformError)(err);
    const currentAd = await dataClient.getAttackDiscovery({
      id: executionUuid,
      authenticatedUser
    });
    if (currentAd === null || (currentAd === null || currentAd === void 0 ? void 0 : currentAd.status) === 'canceled') {
      return;
    }
    await dataClient.updateAttackDiscovery({
      attackDiscoveryUpdateProps: {
        attackDiscoveries: [],
        status: _helpers.attackDiscoveryStatus.failed,
        id: executionUuid,
        replacements: latestReplacements,
        backingIndex: currentAd.backingIndex,
        failureReason: error.message
      },
      authenticatedUser
    });
    (0, _telemetry.reportAttackDiscoveryGenerationFailure)({
      apiConfig,
      errorMessage: error.message,
      telemetry
    });
  } catch (updateErr) {
    const updateError = (0, _securitysolutionEsUtils.transformError)(updateErr);
    (0, _telemetry.reportAttackDiscoveryGenerationFailure)({
      apiConfig,
      errorMessage: updateError.message,
      telemetry
    });
  }
};
exports.handleGraphError = handleGraphError;