"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatPrompt = void 0;
var _prompts = require("@langchain/core/prompts");
var _agentRunnable = require("./agentRunnable");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formatPromptToolcalling = (prompt, additionalPrompt) => _prompts.ChatPromptTemplate.fromMessages([['system', additionalPrompt ? `${prompt}\n\n${additionalPrompt}` : prompt], ['placeholder', '{knowledge_history}'], ['placeholder', '{chat_history}'], ['human', '{input}'], ['placeholder', '{agent_scratchpad}']]);
const formatPromptStructured = (prompt, additionalPrompt) => _prompts.ChatPromptTemplate.fromMessages([['system', additionalPrompt ? `${prompt}\n\n${additionalPrompt}` : prompt], ['placeholder', '{knowledge_history}'], ['placeholder', '{chat_history}'], ['human', '{input}\n\n{agent_scratchpad}\n\n(reminder to respond in a JSON blob no matter what)']]);
const formatPrompt = ({
  llmType,
  prompt,
  additionalPrompt
}) => {
  if (llmType && _agentRunnable.TOOL_CALLING_LLM_TYPES.has(llmType)) {
    return formatPromptToolcalling(prompt, additionalPrompt);
  }
  return formatPromptStructured(prompt, additionalPrompt);
};
exports.formatPrompt = formatPrompt;