"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.agentRunnableFactory = exports.TOOL_CALLING_LLM_TYPES = void 0;
var _agents = require("langchain/agents");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TOOL_CALLING_LLM_TYPES = exports.TOOL_CALLING_LLM_TYPES = new Set(['inference', 'openai', 'bedrock', 'gemini']);
const agentRunnableFactory = async ({
  llm,
  llmType,
  tools,
  inferenceChatModelDisabled,
  isOpenAI,
  isStream,
  prompt
}) => {
  const params = {
    llm,
    tools,
    streamRunnable: isStream,
    prompt
  };
  if (inferenceChatModelDisabled && (isOpenAI || llmType === 'inference')) {
    return (0, _agents.createOpenAIToolsAgent)(params);
  }
  if (llmType && TOOL_CALLING_LLM_TYPES.has(llmType)) {
    return (0, _agents.createToolCallingAgent)(params);
  }
  return (0, _agents.createStructuredChatAgent)(params);
};
exports.agentRunnableFactory = agentRunnableFactory;