"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.combineFindAttackDiscoveryFilters = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _fields = require("../../schedules/fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const escapeQueryString = str => str.replace(/[+\-=&|><!(){}[\]^"~*?:\\/]/g, '\\$&'); // $& means the whole matched string

// returns a KQL filter by combining the provided filters with `AND`
const combineFindAttackDiscoveryFilters = ({
  alertIds,
  connectorNames,
  end,
  ids,
  search,
  start,
  status
}) => {
  const MARKDOWN_FIELDS_WITH_REPLACEMENTS = [_fields.ALERT_ATTACK_DISCOVERY_DETAILS_MARKDOWN_WITH_REPLACEMENTS, _fields.ALERT_ATTACK_DISCOVERY_ENTITY_SUMMARY_MARKDOWN_WITH_REPLACEMENTS, _fields.ALERT_ATTACK_DISCOVERY_SUMMARY_MARKDOWN_WITH_REPLACEMENTS, _fields.ALERT_ATTACK_DISCOVERY_TITLE_WITH_REPLACEMENTS];
  const filters = [...(search != null && search.trim().length > 0 ? [`(${MARKDOWN_FIELDS_WITH_REPLACEMENTS.map(field => `${field}: "*${escapeQueryString(search.trim())}*"`).join(' OR ')})`] : []), ...(ids && ids.length > 0 ? [`(${ids.map(id => `_id: "${id}"`).join(' OR ')})`] : []), ...(status && status.length > 0 ? [`(${status.map(s => `${_ruleDataUtils.ALERT_WORKFLOW_STATUS}: "${s}"`).join(' OR ')})`] : []), ...(connectorNames && connectorNames.length > 0 ? [`(${connectorNames.map(name => `${_fields.ALERT_ATTACK_DISCOVERY_API_CONFIG_NAME}: "${name}"`).join(' OR ')})`] : []), ...(alertIds && alertIds.length > 0 ? [`(${alertIds.map(id => `${_fields.ALERT_ATTACK_DISCOVERY_ALERT_IDS}: "${id}"`).join(' OR ')})`] : []), ...(start ? [`@timestamp >= "${start}"`] : []), ...(end ? [`@timestamp <= "${end}"`] : [])];
  return filters.join(' AND ');
};
exports.combineFindAttackDiscoveryFilters = combineFindAttackDiscoveryFilters;