"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ViewSavedSearchAction = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _get_discover_locator_params = require("../utils/get_discover_locator_params");
var _view_saved_search_compatibility_check = require("./view_saved_search_compatibility_check");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class ViewSavedSearchAction {
  // Same order as ACTION_OPEN_IN_DISCOVER

  constructor(application, locator) {
    (0, _defineProperty2.default)(this, "id", _constants.ACTION_VIEW_SAVED_SEARCH);
    (0, _defineProperty2.default)(this, "type", _constants.ACTION_VIEW_SAVED_SEARCH);
    (0, _defineProperty2.default)(this, "order", 20);
    this.application = application;
    this.locator = locator;
  }
  async execute({
    embeddable
  }) {
    if (!(0, _view_saved_search_compatibility_check.compatibilityCheck)(embeddable)) {
      return;
    }
    const locatorParams = (0, _get_discover_locator_params.getDiscoverLocatorParams)(embeddable);
    await this.locator.navigate(locatorParams);
  }
  getDisplayName() {
    return _i18n.i18n.translate('discover.savedSearchEmbeddable.action.viewSavedSearch.displayName', {
      defaultMessage: 'Open in Discover'
    });
  }
  getIconType() {
    return 'discoverApp';
  }
  async isCompatible({
    embeddable
  }) {
    const {
      capabilities
    } = this.application;
    const hasDiscoverPermissions = capabilities.discover.show || capabilities.discover.save;
    if (!hasDiscoverPermissions) return false; // early return to delay async import until absolutely necessary

    return (0, _view_saved_search_compatibility_check.compatibilityCheck)(embeddable);
  }
}
exports.ViewSavedSearchAction = ViewSavedSearchAction;