"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createObservabilityLogDocumentProfileProvider = void 0;
var _rxjs = require("rxjs");
var _profiles = require("../../../profiles");
var _accessors = require("./accessors");
var _profile = require("../logs_data_source_profile/profile");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createObservabilityLogDocumentProfileProvider = services => ({
  profileId: 'observability-log-document-profile',
  profile: {
    getDocViewer: (0, _accessors.createGetDocViewer)(services)
  },
  resolve: ({
    record,
    rootContext,
    dataSourceContext
  }) => {
    if (rootContext.solutionType !== _profiles.SolutionType.Observability) {
      return {
        isMatch: false
      };
    }
    const isLogRecord = getIsLogRecord(record, services.logsContextService.isLogsIndexPattern);
    if (!isLogRecord) {
      return {
        isMatch: false
      };
    }
    return {
      isMatch: true,
      context: {
        type: _profiles.DocumentType.Log,
        logOverviewContext$: (0, _profile.isLogsDataSourceContext)(dataSourceContext) ? dataSourceContext.logOverviewContext$ : new _rxjs.BehaviorSubject(undefined)
      }
    };
  }
});
exports.createObservabilityLogDocumentProfileProvider = createObservabilityLogDocumentProfileProvider;
const getIsLogRecord = (record, isLogsIndexPattern) => {
  return getDataStreamType(record).includes('logs') || hasFieldsWithPrefix('log.')(record) || getIndices(record).some(isLogsIndexPattern);
};
const getFieldValues = field => record => {
  const value = record.flattened[field];
  return Array.isArray(value) ? value : [value];
};
const getDataStreamType = getFieldValues('data_stream.type');
const getIndices = getFieldValues('_index');
const hasFieldsWithPrefix = prefix => record => {
  return Object.keys(record.flattened).some(field => field.startsWith(prefix) && record.flattened[field] != null);
};