"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFailedDocsPaginated = getFailedDocsPaginated;
var _constants = require("../../../../common/constants");
var _utils = require("../../../../common/utils");
var _get_dataset_aggregated_paginated_results = require("../get_dataset_aggregated_paginated_results");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getFailedDocsPaginated(options) {
  const {
    esClient,
    types,
    datasetQuery,
    start,
    end
  } = options;
  const datasetNames = datasetQuery ? [`${datasetQuery}${_constants.FAILURE_STORE_SELECTOR}`] : types.map(type => (0, _utils.streamPartsToIndexPattern)({
    typePattern: type,
    datasetPattern: `*-*${_constants.FAILURE_STORE_SELECTOR}`
  }));
  return await (0, _get_dataset_aggregated_paginated_results.getAggregatedDatasetPaginatedResults)({
    esClient,
    index: datasetNames.join(','),
    start,
    end
  });
}