"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatasetQualityIndicator = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DatasetQualityIndicator = ({
  isLoading,
  quality,
  textSize = 's'
}) => {
  const translatedQuality = _i18n.i18n.translate('xpack.datasetQuality.datasetQualityIdicator', {
    defaultMessage: '{quality}',
    values: {
      quality: (0, _lodash.capitalize)(quality)
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
    width: "50px",
    height: "20px",
    borderRadius: "m",
    isLoading: isLoading
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_.QualityIndicator, {
    textSize: textSize,
    quality: quality,
    description: translatedQuality,
    isColoredDescription: true
  })));
};
exports.DatasetQualityIndicator = DatasetQualityIndicator;