"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldLimitDocLink = FieldLimitDocLink;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _utils = require("../../../../../../utils");
var _translations = require("../../../../../../../common/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FieldLimitDocLink() {
  const {
    services: {
      docLinks
    }
  } = (0, _utils.useKibanaContextForPlugin)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "datasetQualityManualMitigationsPipelineOfficialDocumentationLink",
    href: docLinks.links.elasticsearch.mappingSettingsLimit,
    target: "_blank",
    className: "eui-displayBlock eui-textRight"
  }, _translations.fieldLimitMitigationOfficialDocumentation);
}