"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Selector = Selector;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const selectorLoading = _i18n.i18n.translate('xpack.datasetQuality.selector.loading', {
  defaultMessage: 'Loading'
});
function Selector({
  dataTestSubj = 'datasetQualitySelectable',
  isLoading,
  options,
  loadingMessage,
  label,
  searchPlaceholder,
  noneAvailableMessage,
  noneMatchingMessage,
  onOptionsChange
}) {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onButtonClick = () => {
    setIsPopoverOpen(!isPopoverOpen);
  };
  const closePopover = () => {
    setIsPopoverOpen(false);
  };
  const renderOption = option => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": `${dataTestSubj}Option-${option.label}`
  }, option.label);
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    "data-test-subj": `${dataTestSubj}Button`,
    iconType: "arrowDown",
    badgeColor: "success",
    onClick: onButtonClick,
    isSelected: isPopoverOpen,
    numFilters: options.length,
    hasActiveFilters: !!options.find(item => item.checked === 'on'),
    numActiveFilters: options.filter(item => item.checked === 'on').length
  }, label);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    "data-test-subj": `${dataTestSubj}Options`,
    searchable: true,
    searchProps: {
      placeholder: searchPlaceholder,
      compressed: true
    },
    "aria-label": label,
    options: options,
    onChange: onOptionsChange,
    isLoading: isLoading,
    loadingMessage: loadingMessage !== null && loadingMessage !== void 0 ? loadingMessage : selectorLoading,
    emptyMessage: noneAvailableMessage,
    noMatchesMessage: noneMatchingMessage,
    renderOption: option => renderOption(option)
  }, (list, search) => /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s"
  }, search), list)));
}