"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentStat = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _fieldTypes = require("@kbn/field-types");
var _mlNumberUtils = require("@kbn/ml-number-utils");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../../../common/constants");
var _kibana_context = require("../../../../../kibana_context");
var _field_vis_config = require("../../../../../../../common/types/field_vis_config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DocumentStat = ({
  config,
  showIcon,
  totalCount
}) => {
  const {
    stats,
    type
  } = config;
  const {
    services: {
      data: {
        fieldFormats
      }
    }
  } = (0, _kibana_context.useDataVisualizerKibana)();
  if (stats === undefined) return null;
  const {
    count,
    sampleCount
  } = stats;
  const total = Math.min(sampleCount !== null && sampleCount !== void 0 ? sampleCount : Infinity, totalCount !== null && totalCount !== void 0 ? totalCount : Infinity);

  // If field exists is docs but we don't have count stats then don't show
  // Otherwise if field doesn't appear in docs at all, show 0%
  const valueCount = count !== null && count !== void 0 ? count : (0, _field_vis_config.isIndexBasedFieldVisConfig)(config) && config.existsInDocs === true ? undefined : 0;
  const docsPercent = valueCount !== undefined && total !== undefined ? `(${total === 0 ? 0 : (0, _mlNumberUtils.roundToDecimalPlace)(valueCount / total * 100)}%)` : null;
  const content = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: 'xs'
  }, fieldFormats.getDefaultInstance(_fieldTypes.KBN_FIELD_TYPES.NUMBER, [_fieldTypes.ES_FIELD_TYPES.INTEGER]).convert(valueCount), ' ', docsPercent);
  const tooltipContent = type === _constants.SUPPORTED_FIELD_TYPES.TEXT ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.sampledPercentageForTextFieldsMsg",
    defaultMessage: "The % of documents for text fields is calculated from a sample of {sampledDocumentsFormatted} {sampledDocuments, plural, one {record} other {records}}.",
    values: {
      sampledDocuments: sampleCount,
      sampledDocumentsFormatted: /*#__PURE__*/_react.default.createElement("strong", null, fieldFormats.getDefaultInstance(_fieldTypes.KBN_FIELD_TYPES.NUMBER, [_fieldTypes.ES_FIELD_TYPES.INTEGER]).convert(sampleCount))
    }
  }) : null;
  const icon = showIcon ? type === _constants.SUPPORTED_FIELD_TYPES.TEXT ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: tooltipContent
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "partial",
    size: 'm',
    className: 'columnHeader__icon'
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "document",
    size: 'm',
    className: 'columnHeader__icon'
  }) : null;
  return valueCount !== undefined ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, icon, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: tooltipContent
  }, content)) : null;
};
exports.DocumentStat = DocumentStat;