"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FileBasedDataVisualizerExpandedRow = void 0;
var _react = _interopRequireDefault(require("react"));
var _use_expanded_row_css = require("./use_expanded_row_css");
var _field_data_expanded_row = require("../stats_table/components/field_data_expanded_row");
var _geo_point_content = require("./geo_point_content/geo_point_content");
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FileBasedDataVisualizerExpandedRow = ({
  item
}) => {
  const config = item;
  const {
    type,
    fieldName
  } = config;
  const dvExpandedRow = (0, _use_expanded_row_css.useExpandedRowCss)();
  function getCardContent() {
    switch (type) {
      case _constants.SUPPORTED_FIELD_TYPES.NUMBER:
        return /*#__PURE__*/_react.default.createElement(_field_data_expanded_row.NumberContent, {
          config: config
        });
      case _constants.SUPPORTED_FIELD_TYPES.BOOLEAN:
        return /*#__PURE__*/_react.default.createElement(_field_data_expanded_row.BooleanContent, {
          config: config
        });
      case _constants.SUPPORTED_FIELD_TYPES.DATE:
        return /*#__PURE__*/_react.default.createElement(_field_data_expanded_row.DateContent, {
          config: config
        });
      case _constants.SUPPORTED_FIELD_TYPES.GEO_POINT:
        return /*#__PURE__*/_react.default.createElement(_geo_point_content.GeoPointContent, {
          config: config
        });
      case _constants.SUPPORTED_FIELD_TYPES.IP:
        return /*#__PURE__*/_react.default.createElement(_field_data_expanded_row.IpContent, {
          config: config
        });
      case _constants.SUPPORTED_FIELD_TYPES.KEYWORD:
      case _constants.SUPPORTED_FIELD_TYPES.VERSION:
        return /*#__PURE__*/_react.default.createElement(_field_data_expanded_row.KeywordContent, {
          config: config
        });
      case _constants.SUPPORTED_FIELD_TYPES.TEXT:
        return /*#__PURE__*/_react.default.createElement(_field_data_expanded_row.TextContent, {
          config: config
        });
      default:
        return /*#__PURE__*/_react.default.createElement(_field_data_expanded_row.OtherContent, {
          config: config
        });
    }
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    css: dvExpandedRow,
    "data-test-subj": `dataVisualizerFieldExpandedRow-${fieldName}`
  }, getCardContent());
};
exports.FileBasedDataVisualizerExpandedRow = FileBasedDataVisualizerExpandedRow;