"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteModalMsg = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const all = _i18n.i18n.translate('indexPatternManagement.dataViewTable.spaceCountAll', {
  defaultMessage: 'all'
});
const dataViewColumnName = _i18n.i18n.translate('indexPatternManagement.dataViewTable.dataViewColumnName', {
  defaultMessage: 'Data view'
});
const spacesColumnName = _i18n.i18n.translate('indexPatternManagement.dataViewTable.spacesColumnName', {
  defaultMessage: 'Spaces'
});
const tableTitle = _i18n.i18n.translate('indexPatternManagement.dataViewTable.tableTitle', {
  defaultMessage: 'Data views selected for deletion'
});
const deleteModalMsg = (views, hasSpaces) => {
  const columns = [{
    field: 'name',
    name: dataViewColumnName,
    sortable: true
  }];
  if (hasSpaces) {
    columns.push({
      field: 'namespaces',
      name: spacesColumnName,
      sortable: true,
      width: '100px',
      align: 'right',
      render: namespaces => namespaces.indexOf('*') !== -1 ? all : namespaces.length
    });
  }
  views.forEach(view => view.name = view.getName());
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    iconType: "warning",
    title: "Data views are deleted from every space they are shared in."
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternManagement.dataViewTable.deleteConfirmSummary",
    defaultMessage: "You'll permanently delete {count, number} {count, plural, one {data view} other {data views}\n}.",
    values: {
      count: views.length
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    tableCaption: tableTitle,
    items: views,
    columns: columns
  }));
};
exports.deleteModalMsg = deleteModalMsg;