"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CallOuts = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const CallOuts = ({
  deprecatedLangsInUse,
  painlessDocLink
}) => {
  if (!deprecatedLangsInUse.length) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "indexPatternManagement.editIndexPattern.scripted.deprecatedLangHeader",
      defaultMessage: "Deprecated languages in use"
    }),
    color: "danger",
    iconType: "cross"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternManagement.editIndexPattern.scripted.deprecationLangLabel.deprecationLangDetail",
    defaultMessage: "The following deprecated languages are in use: {deprecatedLangsInUse}. Support for these languages will be removed in the next major version of Kibana and Elasticsearch. Convert your scripted fields to {link} to avoid any problems.",
    values: {
      deprecatedLangsInUse: deprecatedLangsInUse.join(', '),
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: painlessDocLink
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternManagement.editIndexPattern.scripted.deprecationLangLabel.painlessDescription",
        defaultMessage: "Painless"
      }))
    }
  }))));
};
exports.CallOuts = CallOuts;